/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.quetzalcoatl_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class FeetQuetzalcoatlArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart legFeatherRight;
    private final ModelPart legFeatherLeft;

    public FeetQuetzalcoatlArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.legFeatherRight = this.rightLeg.getChild("legFeatherRight");
        this.legFeatherLeft = this.leftLeg.getChild("legFeatherLeft");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new FeetQuetzalcoatlArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = FeetQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition rightLeg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 37).addBox(-2.5f, 1.5f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("legFeatherRight", CubeListBuilder.create().texOffs(50, 23).addBox(-0.3f, -2.0f, -1.0f, 0.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.1f, (float)2.25f, (float)0.0f, (float)-0.7931f, (float)-0.1231f, (float)0.124f));
        rightLeg.addOrReplaceChild("legJewelRight", CubeListBuilder.create().texOffs(45, 19).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.1f, (float)2.25f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("legProtectionRight", CubeListBuilder.create().texOffs(88, 29).addBox(-1.5f, -2.5f, -1.5f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)-1.25f, (float)8.0f, (float)-1.25f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition leftLeg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 37).mirror(true).addBox(-2.5f, 1.5f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("legFeatherLeft", CubeListBuilder.create().texOffs(50, 23).mirror(true).addBox(0.3f, -2.0f, -1.0f, 0.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.1f, (float)2.25f, (float)0.0f, (float)-0.7931f, (float)0.1231f, (float)-0.124f));
        leftLeg.addOrReplaceChild("legProtectionLeft", CubeListBuilder.create().texOffs(88, 29).mirror(true).addBox(-1.5f, -2.5f, -1.5f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)1.25f, (float)8.0f, (float)-1.25f, (float)0.0f, (float)0.0f, (float)0.0873f));
        leftLeg.addOrReplaceChild("legJewelLeft", CubeListBuilder.create().texOffs(45, 19).mirror(true).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.1f, (float)2.25f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rf;
        this.legFeatherRight.xRot = rf = -0.7931f + 0.2f * FeetQuetzalcoatlArmorModel.sinPI((ageInTicks + 10.0f) / 40.0f);
        this.legFeatherLeft.xRot = rf;
    }
}

