/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.quetzalcoatl_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestQuetzalcoatlArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart tail;
    private final ModelPart tailTip;
    private final ModelPart armFeather;
    private final ModelPart neckStart;
    private final ModelPart neckEnd;
    private final ModelPart snakeHead;
    private final ModelPart jow;
    private final ModelPart snakeCrownRight;
    private final ModelPart snakeCrownLeft;

    public ChestQuetzalcoatlArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.tail = this.body.getChild("tail");
        this.tailTip = this.tail.getChild("tailTip");
        this.armFeather = this.leftArm.getChild("armFeather");
        this.neckStart = this.body.getChild("neckStart");
        this.neckEnd = this.neckStart.getChild("neckEnd");
        this.snakeHead = this.neckEnd.getChild("snakeHead");
        this.jow = this.snakeHead.getChild("jow");
        this.snakeCrownRight = this.snakeHead.getChild("snakeCrownRight");
        this.snakeCrownLeft = this.snakeHead.getChild("snakeCrownLeft");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestQuetzalcoatlArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -0.5f, -2.5f, 8.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("snakeA", CubeListBuilder.create().texOffs(50, 19).addBox(-6.0f, 0.0f, -3.0f, 3.0f, 3.0f, 5.0f, CubeDeformation.NONE).texOffs(76, 0).addBox(-6.0f, 0.0f, 2.0f, 12.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.67f, (float)0.2454f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeB", CubeListBuilder.create().texOffs(85, 11).addBox(3.5f, 2.5f, -3.25f, 3.0f, 3.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.6523f, (float)-0.9639f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeC", CubeListBuilder.create().texOffs(98, 10).addBox(3.5f, -2.5f, -3.0f, 3.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.6523f, (float)-0.9639f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeD", CubeListBuilder.create().texOffs(114, 18).addBox(3.25f, -5.5f, -3.5f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0428f, (float)1.4415f, (float)-2.6225f, (float)-1.0308f, (float)-0.0415f, (float)0.1632f));
        PartDefinition neckStart = body.addOrReplaceChild("neckStart", CubeListBuilder.create().texOffs(102, 18).addBox(-1.3977f, -6.9113f, -2.4979f, 3.0f, 7.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)8.0f, (float)-1.25f, (float)1.5f, (float)-0.6929f, (float)0.0315f, (float)0.1992f));
        PartDefinition neckEnd = neckStart.addOrReplaceChild("neckEnd", CubeListBuilder.create().texOffs(110, 10).addBox(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.0551f, (float)-6.6055f, (float)-0.1796f, (float)0.9904f, (float)0.0148f, (float)-0.0067f));
        neckEnd.addOrReplaceChild("featherA", CubeListBuilder.create().texOffs(100, 0).addBox(-0.2694f, -0.4602f, -2.4251f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.1511f, (float)-1.337f, (float)1.1273f, (float)-1.078f, (float)0.7476f, (float)0.3405f));
        neckEnd.addOrReplaceChild("featherB", CubeListBuilder.create().texOffs(68, 6).addBox(0.5858f, 0.3358f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-0.1511f, (float)-6.337f, (float)1.1273f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        PartDefinition snakeHead = neckEnd.addOrReplaceChild("snakeHead", CubeListBuilder.create().texOffs(61, 19).mirror().addBox(-1.9512f, -1.3244f, -7.3903f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(86, 6).addBox(-1.4512f, -0.5744f, -6.8903f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(52, 5).addBox(-1.9512f, -3.3244f, -3.3903f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.1999f, (float)-5.0126f, (float)-0.4824f, (float)0.1176f, (float)0.0076f, (float)-0.0741f));
        snakeHead.addOrReplaceChild("snakeCrownLeft", CubeListBuilder.create().texOffs(26, 7).addBox(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-2.5831f, (float)0.3378f, (float)-2.9374f));
        snakeHead.addOrReplaceChild("snakeCrownRight", CubeListBuilder.create().texOffs(26, 7).addBox(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-0.5585f, (float)0.3378f, (float)-0.2042f));
        snakeHead.addOrReplaceChild("featherC", CubeListBuilder.create().texOffs(68, 6).addBox(-0.1642f, -0.1642f, -2.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-1.3244f, (float)1.6097f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        snakeHead.addOrReplaceChild("featherD", CubeListBuilder.create().texOffs(68, 6).addBox(0.25f, 0.25f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0488f, (float)-3.3244f, (float)1.6097f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snakeHead.addOrReplaceChild("featherE", CubeListBuilder.create().texOffs(68, 6).addBox(-0.2324f, -0.25f, -0.3181f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0488f, (float)-3.3244f, (float)-0.3903f, (float)0.4711f, (float)-0.3981f, (float)0.6996f));
        snakeHead.addOrReplaceChild("headA", CubeListBuilder.create().texOffs(120, 6).addBox(-4.9f, -1.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)3.4488f, (float)-1.28f, (float)-6.2866f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        snakeHead.addOrReplaceChild("headB", CubeListBuilder.create().texOffs(114, 0).addBox(-3.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0488f, (float)-3.3244f, (float)-3.3903f, (float)0.3491f, (float)0.0f, (float)0.0f));
        snakeHead.addOrReplaceChild("headC", CubeListBuilder.create().texOffs(68, 8).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.4204f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)0.1398f, (float)0.224f));
        snakeHead.addOrReplaceChild("headD", CubeListBuilder.create().texOffs(68, 5).addBox(-1.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.4512f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)-0.5398f, (float)0.0571f));
        snakeHead.addOrReplaceChild("headE", CubeListBuilder.create().texOffs(119, 8).addBox(-0.45f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-1.9512f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        snakeHead.addOrReplaceChild("headF", CubeListBuilder.create().texOffs(68, 8).mirror().addBox(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.5179f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)-0.1398f, (float)-0.224f));
        snakeHead.addOrReplaceChild("headG", CubeListBuilder.create().texOffs(68, 5).mirror().addBox(0.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5488f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)0.5398f, (float)-0.0571f));
        snakeHead.addOrReplaceChild("headH", CubeListBuilder.create().texOffs(119, 8).mirror().addBox(-1.55f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)2.0488f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)0.2618f, (float)0.0f));
        snakeHead.addOrReplaceChild("jow", CubeListBuilder.create().texOffs(73, 18).mirror().addBox(-3.4471f, 0.7487f, -5.805f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(86, 6).addBox(-2.9471f, -0.0013f, -5.305f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(52, 13).addBox(-3.9471f, -1.2513f, -1.805f, 5.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.4959f, (float)0.4269f, (float)-1.5853f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(87, 21).addBox(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.9225f, (float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition tailTip = tail.addOrReplaceChild("tailTip", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)6.0f, (float)0.5f));
        tailTip.addOrReplaceChild("tailTipFeather", CubeListBuilder.create().texOffs(20, 33).addBox(1.0f, 0.0f, -1.0f, 0.0f, 9.0f, 3.0f, CubeDeformation.NONE).texOffs(96, 21).addBox(-0.5f, 0.0f, 0.5f, 3.0f, 9.0f, 0.0f, CubeDeformation.NONE).texOffs(122, 12).addBox(0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        body.addOrReplaceChild("necklaceJewel", CubeListBuilder.create().texOffs(21, 20).addBox(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(30, 19).addBox(-3.5f, 0.5f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("shoulderRightProtection", CubeListBuilder.create().texOffs(20, 24).addBox(-0.5f, -5.25f, -0.4f, 2.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.6f, (float)0.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 29).mirror(true).addBox(-1.5f, 5.5f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.addOrReplaceChild("leftArmJewel", CubeListBuilder.create().texOffs(29, 20).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.5f, (float)7.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("armFeather", CubeListBuilder.create().texOffs(36, 19).addBox(0.15f, -5.0f, -3.5f, 0.0f, 10.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.75f, (float)5.5f, (float)1.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -0.5f, -2.5f, 8.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("snakeA", CubeListBuilder.create().texOffs(50, 19).addBox(-6.0f, 0.0f, -3.0f, 3.0f, 3.0f, 5.0f, CubeDeformation.NONE).texOffs(76, 0).addBox(-6.0f, 0.0f, 2.0f, 12.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.67f, (float)0.2454f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeB", CubeListBuilder.create().texOffs(85, 11).addBox(3.5f, 2.5f, -3.25f, 3.0f, 3.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.6523f, (float)-0.9639f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeC", CubeListBuilder.create().texOffs(98, 10).addBox(3.5f, -2.5f, -3.0f, 3.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.6523f, (float)-0.9639f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.addOrReplaceChild("snakeD", CubeListBuilder.create().texOffs(114, 18).addBox(3.25f, -5.5f, -3.5f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0428f, (float)1.4415f, (float)-2.6225f, (float)-1.0308f, (float)-0.0415f, (float)0.1632f));
        PartDefinition neckStart = body.addOrReplaceChild("neckStart", CubeListBuilder.create().texOffs(102, 18).addBox(-1.3977f, -6.9113f, -2.4979f, 3.0f, 7.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)8.0f, (float)-1.25f, (float)1.5f, (float)-0.6929f, (float)0.0315f, (float)0.1992f));
        PartDefinition neckEnd = neckStart.addOrReplaceChild("neckEnd", CubeListBuilder.create().texOffs(110, 10).addBox(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.0551f, (float)-6.6055f, (float)-0.1796f, (float)0.9904f, (float)0.0148f, (float)-0.0067f));
        neckEnd.addOrReplaceChild("featherA", CubeListBuilder.create().texOffs(100, 0).addBox(-0.2694f, -0.4602f, -2.4251f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.1511f, (float)-1.337f, (float)1.1273f, (float)-1.078f, (float)0.7476f, (float)0.3405f));
        neckEnd.addOrReplaceChild("featherB", CubeListBuilder.create().texOffs(68, 6).addBox(0.5858f, 0.3358f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-0.1511f, (float)-6.337f, (float)1.1273f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        PartDefinition snakeHead = neckEnd.addOrReplaceChild("snakeHead", CubeListBuilder.create().texOffs(61, 19).mirror().addBox(-1.9512f, -1.3244f, -7.3903f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(86, 6).addBox(-1.4512f, -0.5744f, -6.8903f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(52, 5).addBox(-1.9512f, -3.3244f, -3.3903f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.1999f, (float)-5.0126f, (float)-0.4824f, (float)0.1176f, (float)0.0076f, (float)-0.0741f));
        snakeHead.addOrReplaceChild("snakeCrownLeft", CubeListBuilder.create().texOffs(26, 7).addBox(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-2.5831f, (float)0.3378f, (float)-2.9374f));
        snakeHead.addOrReplaceChild("snakeCrownRight", CubeListBuilder.create().texOffs(26, 7).addBox(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-0.5585f, (float)0.3378f, (float)-0.2042f));
        snakeHead.addOrReplaceChild("featherC", CubeListBuilder.create().texOffs(68, 6).addBox(-0.1642f, -0.1642f, -2.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0488f, (float)-1.3244f, (float)1.6097f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        snakeHead.addOrReplaceChild("featherD", CubeListBuilder.create().texOffs(68, 6).addBox(0.25f, 0.25f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0488f, (float)-3.3244f, (float)1.6097f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snakeHead.addOrReplaceChild("featherE", CubeListBuilder.create().texOffs(68, 6).addBox(-0.2324f, -0.25f, -0.3181f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0488f, (float)-3.3244f, (float)-0.3903f, (float)0.4711f, (float)-0.3981f, (float)0.6996f));
        snakeHead.addOrReplaceChild("headA", CubeListBuilder.create().texOffs(120, 6).addBox(-4.9f, -1.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)3.4488f, (float)-1.28f, (float)-6.2866f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        snakeHead.addOrReplaceChild("headB", CubeListBuilder.create().texOffs(114, 0).addBox(-3.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0488f, (float)-3.3244f, (float)-3.3903f, (float)0.3491f, (float)0.0f, (float)0.0f));
        snakeHead.addOrReplaceChild("headC", CubeListBuilder.create().texOffs(68, 8).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.4204f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)0.1398f, (float)0.224f));
        snakeHead.addOrReplaceChild("headD", CubeListBuilder.create().texOffs(68, 5).addBox(-1.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.4512f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)-0.5398f, (float)0.0571f));
        snakeHead.addOrReplaceChild("headE", CubeListBuilder.create().texOffs(119, 8).addBox(-0.45f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-1.9512f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        snakeHead.addOrReplaceChild("headF", CubeListBuilder.create().texOffs(68, 8).mirror().addBox(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.5179f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)-0.1398f, (float)-0.224f));
        snakeHead.addOrReplaceChild("headG", CubeListBuilder.create().texOffs(68, 5).mirror().addBox(0.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5488f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)0.5398f, (float)-0.0571f));
        snakeHead.addOrReplaceChild("headH", CubeListBuilder.create().texOffs(119, 8).mirror().addBox(-1.55f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)2.0488f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)0.2618f, (float)0.0f));
        snakeHead.addOrReplaceChild("jow", CubeListBuilder.create().texOffs(73, 18).mirror().addBox(-3.4471f, 0.7487f, -5.805f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(86, 6).addBox(-2.9471f, -0.0013f, -5.305f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(52, 13).addBox(-3.9471f, -1.2513f, -1.805f, 5.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.4959f, (float)0.4269f, (float)-1.5853f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(87, 21).addBox(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.9225f, (float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition tailTip = tail.addOrReplaceChild("tailTip", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)6.0f, (float)0.5f));
        tailTip.addOrReplaceChild("tailTipFeather", CubeListBuilder.create().texOffs(20, 33).addBox(1.0f, 0.0f, -1.0f, 0.0f, 9.0f, 3.0f, CubeDeformation.NONE).texOffs(96, 21).addBox(-0.5f, 0.0f, 0.5f, 3.0f, 9.0f, 0.0f, CubeDeformation.NONE).texOffs(122, 12).addBox(0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        body.addOrReplaceChild("chestBreast", CubeListBuilder.create().texOffs(26, 40).addBox(-3.5f, -1.75f, 0.0f, 7.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-3.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("necklaceJewel", CubeListBuilder.create().texOffs(21, 20).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-2.5f, (float)-0.3527f, (float)0.3326f, (float)0.7256f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(30, 19).addBox(-2.5f, 0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("shoulderRightProtection", CubeListBuilder.create().texOffs(20, 24).addBox(0.5f, -5.25f, -0.4f, 2.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.6f, (float)0.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 29).mirror(true).addBox(-1.5f, 5.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.addOrReplaceChild("leftArmJewel", CubeListBuilder.create().texOffs(29, 20).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.5f, (float)7.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("armFeather", CubeListBuilder.create().texOffs(36, 19).addBox(0.15f, -5.0f, -3.5f, 0.0f, 10.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.75f, (float)5.5f, (float)1.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rA = ChestQuetzalcoatlArmorModel.sinPI(ageInTicks / 40.0f);
        float rB = ChestQuetzalcoatlArmorModel.sinPI((ageInTicks - 15.0f) / 40.0f);
        this.tail.xRot = this.rightArm.xRot < 0.0f ? this.rightArm.xRot : this.rightArm.xRot * 0.1f;
        this.tail.zRot = 0.2182f + 0.1f * rA;
        this.tailTip.zRot = 0.1f * rB;
        this.armFeather.zRot = -0.05f * rB;
        this.armFeather.xRot = 0.1f * rB;
        this.neckStart.xRot = -0.3f + 0.2f * rA;
        this.neckStart.zRot = 0.2f + 0.04f * rB;
        this.neckEnd.xRot = 0.6f + 0.1f * rB;
        this.snakeHead.xRot = -0.2f * rB + 0.02f * headPitch;
        this.snakeHead.yRot = 0.02f * netHeadYaw;
        this.jow.xRot = 0.13f + 0.1f * rA;
        this.snakeCrownRight.yRot = 0.3378f + 0.1f * rB;
        this.snakeCrownLeft.yRot = 0.3378f - 0.1f * rB;
    }
}

