/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.pharaoh_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class LegsPharaohArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart bodyGoldenStrip;
    private final ModelPart bodyJewel;

    public LegsPharaohArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.bodyGoldenStrip = this.body.getChild("bodyGoldenStrip");
        this.bodyJewel = this.body.getChild("bodyJewel");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new LegsPharaohArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = LegsPharaohArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 10).addBox(-4.5f, 8.5f, -2.5f, 9.0f, 4.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("bodyJewel", CubeListBuilder.create().texOffs(56, 10).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        body.addOrReplaceChild("bodyGoldenStrip", CubeListBuilder.create().texOffs(56, 14).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 8.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.0f, (float)-2.6f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 33).mirror(true).addBox(-2.5f, -0.5f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 33).addBox(-2.5f, -0.5f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.bodyGoldenStrip.xRot = Math.abs(this.rightLeg.xRot);
        if (this.riding) {
            this.bodyGoldenStrip.xRot -= 1.0f;
        }
        this.bodyGoldenStrip.y = 10.0f;
        this.bodyJewel.y = 10.0f;
    }
}

