/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.japanese_light_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadJapaneseLightArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart ribbonA;
    private final ModelPart ribbonB;

    public HeadJapaneseLightArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.ribbonA = root.getChild("head").getChild("ribbonA");
        this.ribbonB = root.getChild("head").getChild("ribbonB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadJapaneseLightArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadJapaneseLightArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 16).addBox(-4.0f, -6.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.55f)), PartPose.ZERO);
        head.addOrReplaceChild("knotBase", CubeListBuilder.create().texOffs(56, 9).addBox(2.9f, -4.9f, 3.7f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.785f));
        head.addOrReplaceChild("ribbonA", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 7.0f, 0.01f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)4.1f, (float)0.35f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("ribbonB", CubeListBuilder.create().texOffs(60, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 9.0f, 0.01f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)4.1f, (float)0.175f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 0.3f * HeadJapaneseLightArmorModel.sinPI(ageInTicks / 60.0f + 1.0f) + Math.abs(this.rightLeg.xRot);
        this.ribbonA.xRot = Math.max(0.35f + f * 0.15f - this.head.xRot, 0.2f);
        this.ribbonA.zRot = -0.1f + f * 0.2f;
        this.ribbonB.xRot = Math.max(0.175f + f * 0.1f - this.head.xRot, 0.075f);
        this.ribbonB.zRot = -f * 0.2f;
    }
}

