/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.holy_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class FeetHolyArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart legLeftWing;
    private final ModelPart legRightWing;

    public FeetHolyArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.legLeftWing = this.leftLeg.getChild("leg_left_wing");
        this.legRightWing = this.rightLeg.getChild("leg_right_wing");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new FeetHolyArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = FeetHolyArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition leg_left = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(66, 31).addBox(-2.5f, -0.7f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)).texOffs(48, 57).addBox(-2.5f, 10.3f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(25, 43).addBox(-2.5f, 5.3f, -2.6f, 5.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(2.0f, 5.8f, -1.1f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        leg_left.addOrReplaceChild("leg_left_wing", CubeListBuilder.create().texOffs(0, 55).addBox(0.0f, -2.3f, 0.0f, 0.0f, 3.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.501f, (float)6.3f, (float)-1.6f, (float)-0.3491f, (float)0.3054f, (float)0.0f));
        PartDefinition leg_right = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(66, 31).mirror().addBox(-2.5f, -0.7f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)).mirror(false).texOffs(48, 57).mirror().addBox(-2.5f, 10.3f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(25, 43).mirror().addBox(-2.5f, 5.3f, -2.6f, 5.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 6).addBox(-3.0f, 5.8f, -1.1f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        leg_right.addOrReplaceChild("leg_right_wing", CubeListBuilder.create().texOffs(0, 55).mirror().addBox(0.0f, -2.3f, 0.0f, 0.0f, 3.0f, 5.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-2.501f, (float)6.3f, (float)-1.6f, (float)-0.1745f, (float)-0.3054f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.legLeftWing.xRot = -0.1745f + 0.1f * FeetHolyArmorModel.sinPI(ageInTicks / 40.0f);
        this.legRightWing.xRot = -0.1745f + 0.1f * FeetHolyArmorModel.sinPI(ageInTicks / 40.0f);
    }
}

