/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.anubis_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class LegsAnubisArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart ribbonLegs;

    public LegsAnubisArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.ribbonLegs = this.body.getChild("ribbonLegs");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new LegsAnubisArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = LegsAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(65, 18).addBox(-4.5f, 9.5f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.1f)).texOffs(49, 25).addBox(-4.5f, 10.5f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(-0.05f)).texOffs(67, 0).addBox(-1.5f, 8.75f, -2.75f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.ZERO);
        body.addOrReplaceChild("ribbonLegs", CubeListBuilder.create().texOffs(14, 16).addBox(-1.5f, 0.0f, -0.25f, 3.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.75f, (float)-2.5f));
        PartDefinition leftLeg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(112, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(38, 32).addBox(-2.4f, 0.4f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("layerLegLeft", CubeListBuilder.create().mirror().texOffs(108, 18).addBox(-0.75f, -2.25f, -2.5f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.15f)), PartPose.offsetAndRotation((float)1.85f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightLeg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(112, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(38, 32).addBox(-2.6f, 0.4f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("layerLegRight", CubeListBuilder.create().texOffs(108, 18).addBox(-1.25f, -2.25f, -2.5f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.15f)), PartPose.offsetAndRotation((float)-1.85f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ribbonLegs.xRot = -Math.abs(0.05f + 1.02f * this.rightLeg.xRot) + 0.05f * (1.0f + LegsAnubisArmorModel.sinPI(ageInTicks / 40.0f));
    }
}

