/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.anubis_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestAnubisArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart collarBack;
    private final ModelPart crossA;
    private final ModelPart crossB;
    private final ModelPart crossC;
    private final ModelPart crossD;

    public ChestAnubisArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.collarBack = this.body.getChild("collar_back");
        this.crossA = this.body.getChild("cross_a");
        this.crossB = this.body.getChild("cross_b");
        this.crossC = this.body.getChild("cross_c");
        this.crossD = this.body.getChild("cross_d");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestAnubisArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(70, 0).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.22f)).texOffs(-6, 52).addBox(-4.5f, -0.45f, -2.5f, 9.0f, 0.0f, 6.0f), PartPose.ZERO);
        body.addOrReplaceChild("abs", CubeListBuilder.create().texOffs(38, 21).addBox(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_back", CubeListBuilder.create().texOffs(20, 31).addBox(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("collar_front", CubeListBuilder.create().texOffs(-5, 58).addBox(-4.5f, 0.0f, -5.0f, 9.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.45f, (float)-2.5f, (float)1.309f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("collar_back", CubeListBuilder.create().texOffs(-8, 44).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 0.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.45f, (float)3.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_core", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -3.5f, 0.05f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-3.6f, (float)-0.192f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_pec_right", CubeListBuilder.create().texOffs(108, 10).addBox(-4.0f, -4.0f, -2.9f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)-0.2618f));
        body.addOrReplaceChild("chest_pec_left", CubeListBuilder.create().texOffs(108, 10).addBox(0.0f, -4.0f, -2.9f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.2007f, (float)0.0f, (float)0.2618f));
        body.addOrReplaceChild("cross_a", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_b", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_c", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_d", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(112, 48).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 26).addBox(-3.5f, -2.5f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(112, 0).addBox(-1.75f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).texOffs(25, 0).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f).texOffs(18, 16).addBox(-3.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-2.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(112, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 26).addBox(-1.5f, -2.5f, -2.5f, 5.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().mirror().texOffs(112, 0).addBox(-1.25f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).texOffs(25, 0).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f).texOffs(18, 16).addBox(-1.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)2.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestAnubisArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(70, 0).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.22f)).texOffs(-6, 52).addBox(-4.5f, -0.45f, -2.5f, 9.0f, 0.0f, 6.0f, CubeDeformation.NONE), PartPose.ZERO);
        body.addOrReplaceChild("abs", CubeListBuilder.create().texOffs(38, 21).addBox(-3.5f, -1.0f, 0.3f, 7.0f, 8.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)4.7f, (float)-3.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_back", CubeListBuilder.create().texOffs(20, 31).addBox(-3.5f, -6.5f, -1.7f, 7.0f, 12.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("collar_front", CubeListBuilder.create().texOffs(-5, 58).addBox(-4.5f, 0.0f, -5.0f, 9.0f, 0.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.45f, (float)-2.5f, (float)1.1345f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("collar_back", CubeListBuilder.create().texOffs(-8, 44).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 0.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.45f, (float)3.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_core", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -1.2974f, -0.1f, 2.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)-3.6f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest_pec_right", CubeListBuilder.create().texOffs(108, 10).addBox(-4.0f, -3.0f, -3.5f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)-0.1745f));
        body.addOrReplaceChild("chest_pec_left", CubeListBuilder.create().texOffs(108, 10).addBox(0.0f, -3.0f, -3.5f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)-0.5f, (float)-0.3752f, (float)0.0f, (float)0.1745f));
        body.addOrReplaceChild("cross_a", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_b", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_c", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        body.addOrReplaceChild("cross_d", CubeListBuilder.create().texOffs(18, 45).addBox(-2.5f, -44.0f, 2.0f, 5.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(112, 48).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 26).addBox(-2.5f, -2.5f, -2.5f, 4.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(112, 0).addBox(-1.75f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).texOffs(25, 0).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f, CubeDeformation.NONE).texOffs(18, 16).addBox(-3.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)-1.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(112, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 26).addBox(-1.5f, -2.5f, -2.5f, 4.0f, 13.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_shoulder", CubeListBuilder.create().mirror().texOffs(112, 0).addBox(-1.25f, -2.0f, -2.5f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.05f)).texOffs(25, 0).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 1.0f, CubeDeformation.NONE).texOffs(18, 16).addBox(-1.0f, -6.0f, -3.0f, 4.0f, 9.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)1.25f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.collarBack.xRot = -1.5708f + 0.08f * (1.0f + ChestAnubisArmorModel.sinPI(ageInTicks / 40.0f));
        this.crossA.x = this.getOrbitalX(8.5f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 40.0f), 0.5f, ageInTicks);
        this.crossA.y = this.getOrbitalY(8.5f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 10.0f) / 30.0f), -0.5f, ageInTicks);
        this.crossB.x = this.getOrbitalX(8.0f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 70.0f), 0.45f, ageInTicks + 5.0f);
        this.crossB.y = this.getOrbitalY(8.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 10.0f) / 40.0f), 0.45f, ageInTicks + 25.0f);
        this.crossC.x = this.getOrbitalX(9.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 25.0f) / 30.0f), 0.55f, ageInTicks + 25.0f);
        this.crossC.y = this.getOrbitalY(9.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 5.0f) / 50.0f), 0.55f, ageInTicks + 30.0f);
        this.crossD.x = this.getOrbitalX(8.0f + 2.0f * ChestAnubisArmorModel.sinPI((ageInTicks + 30.0f) / 80.0f), 0.42f, ageInTicks + 20.0f);
        this.crossD.y = this.getOrbitalY(8.0f + 2.0f * ChestAnubisArmorModel.sinPI(ageInTicks / 50.0f), 0.42f, ageInTicks + 20.0f);
    }

    private float getOrbitalX(float amplitude, float frequency, float ageInTicks) {
        return amplitude * ChestAnubisArmorModel.cosPI(2.0f * frequency * ageInTicks / 40.0f);
    }

    private float getOrbitalY(float amplitude, float frequency, float ageInTicks) {
        return 30.0f + amplitude * ChestAnubisArmorModel.sinPI(2.0f * frequency * ageInTicks / 40.0f);
    }
}

