/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.jetbrains.annotations.NotNull;

public abstract class ArmorModel<T extends LivingEntity>
extends HumanoidModel<T>
implements ArmorModelSupplier {
    public final boolean isSlim;

    public ArmorModel(ModelPart root, boolean isSlim) {
        super(root);
        this.isSlim = isSlim;
    }

    protected abstract void setupArmorPartAnim(float var1, float var2, float var3, float var4, float var5);

    public static MeshDefinition templateLayerDefinition(float scale) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)(0.0f + scale), (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)(2.0f + scale), (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)(2.0f + scale), (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-1.9f, (float)(12.0f + scale), (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)1.9f, (float)(12.0f + scale), (float)0.0f));
        return mesh;
    }

    public void setupAnim(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof ArmorStand) {
            ArmorStand entityAS = (ArmorStand)entity;
            float f = (float)Math.PI / 180;
            this.head.xRot = f * entityAS.getHeadPose().getX();
            this.head.yRot = f * entityAS.getHeadPose().getY();
            this.head.zRot = f * entityAS.getHeadPose().getZ();
            this.body.xRot = f * entityAS.getBodyPose().getX();
            this.body.yRot = f * entityAS.getBodyPose().getY();
            this.body.zRot = f * entityAS.getBodyPose().getZ();
            this.leftArm.xRot = f * entityAS.getLeftArmPose().getX();
            this.leftArm.yRot = f * entityAS.getLeftArmPose().getY();
            this.leftArm.zRot = f * entityAS.getLeftArmPose().getZ();
            this.rightArm.xRot = f * entityAS.getRightArmPose().getX();
            this.rightArm.yRot = f * entityAS.getRightArmPose().getY();
            this.rightArm.zRot = f * entityAS.getRightArmPose().getZ();
            this.leftLeg.xRot = f * entityAS.getLeftLegPose().getX();
            this.leftLeg.yRot = f * entityAS.getLeftLegPose().getY();
            this.leftLeg.zRot = f * entityAS.getLeftLegPose().getZ();
            this.rightLeg.xRot = f * entityAS.getRightLegPose().getX();
            this.rightLeg.yRot = f * entityAS.getRightLegPose().getY();
            this.rightLeg.zRot = f * entityAS.getRightLegPose().getZ();
        } else {
            this.setupArmorPartAnim(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static float sinPI(float f) {
        return Mth.sin((float)(f * (float)Math.PI));
    }

    public static float cosPI(float f) {
        return Mth.cos((float)(f * (float)Math.PI));
    }

    public <M extends HumanoidModel<? extends LivingEntity>> void copyEntityModelPosition(M parentModel) {
        this.leftArmPose = parentModel.leftArmPose;
        this.rightArmPose = parentModel.rightArmPose;
        this.crouching = parentModel.crouching;
        this.head.copyFrom(parentModel.head);
        this.hat.copyFrom(parentModel.hat);
        this.body.copyFrom(parentModel.body);
        this.rightArm.copyFrom(parentModel.rightArm);
        this.leftArm.copyFrom(parentModel.leftArm);
        this.rightLeg.copyFrom(parentModel.rightLeg);
        this.leftLeg.copyFrom(parentModel.leftLeg);
    }
}

