/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.dawnoftime.armoroftheages.AotAItemRegistry;
import org.dawnoftime.armoroftheages.CommonClass;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.item.ForgeHumanoidArmorItem;
import org.dawnoftime.armoroftheages.registry.ModelProviderRegistry;
import org.jetbrains.annotations.NotNull;

public class ArmorOfTheAgesClientNeoforge {
    public static void setup(IEventBus bus) {
        bus.addListener(ArmorOfTheAgesClientNeoforge::registerLayerDefinitions);
        bus.addListener(ArmorOfTheAgesClientNeoforge::onRegisterClientExtensions);
        NeoForge.EVENT_BUS.addListener(ArmorOfTheAgesClientNeoforge::playerLoggedInEvent);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModelProviderRegistry.REGISTRY.forEach((name, provider) -> {
            event.registerLayerDefinition(provider.getLayerLocation(), provider::createLayer);
            if (provider instanceof ArmorModelProvider.MixedArmorModelProvider) {
                ArmorModelProvider.MixedArmorModelProvider slimProvide = (ArmorModelProvider.MixedArmorModelProvider)provider;
                event.registerLayerDefinition(slimProvide.getSlimLayerLocation(), slimProvide::createSlimLayer);
            }
        });
    }

    public static void playerLoggedInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        CommonClass.CONFIG_SYNC_HANDLER.syncConfig();
    }

    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        AotAItemRegistry.ITEMS.getEntries().forEach(itemDeferredHolder -> {
            Object patt0$temp = itemDeferredHolder.get();
            if (patt0$temp instanceof ForgeHumanoidArmorItem) {
                final ForgeHumanoidArmorItem armorItem = (ForgeHumanoidArmorItem)((Object)((Object)patt0$temp));
                event.registerItem(new IClientItemExtensions(){

                    @NotNull
                    public HumanoidModel<?> getHumanoidArmorModel(@NotNull LivingEntity living, @NotNull ItemStack stack, @NotNull EquipmentSlot slot, @NotNull HumanoidModel<?> defaultModel) {
                        ArmorModelProvider provider = armorItem.getModelProvider();
                        if (provider != null) {
                            ArmorModel<?> model = provider.getArmorModel((Entity)living);
                            model.crouching = living.isShiftKeyDown();
                            model.riding = defaultModel.riding;
                            return model;
                        }
                        return defaultModel;
                    }
                }, new Item[]{armorItem});
            }
        });
    }
}

