/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages;

import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.dawnoftime.armoroftheages.AotAArmorMaterialRegistry;
import org.dawnoftime.armoroftheages.AotAItemRegistry;
import org.dawnoftime.armoroftheages.CommonClass;
import org.dawnoftime.armoroftheages.Constants;
import org.dawnoftime.armoroftheages.client.ArmorOfTheAgesClientNeoforge;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.networking.NeoforgeConfigSyncNetworkHandler;
import org.dawnoftime.armoroftheages.networking.packets.C2SDisablePreferencesPacket;
import org.dawnoftime.armoroftheages.networking.packets.C2SPreferenceSyncPacket;
import org.dawnoftime.armoroftheages.networking.packets.S2CPreferenceSyncPacket;

@Mod(value="armoroftheages")
public class ArmorOfTheAges {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"armoroftheages");

    public ArmorOfTheAges(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        CommonClass.CONFIG_SYNC_HANDLER = new NeoforgeConfigSyncNetworkHandler();
        Constants.CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("armoroftheages.json");
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> AOTAConfig.createScreen().generateScreen(parent));
        modEventBus.addListener(this::registerPackets);
        AotAArmorMaterialRegistry.ARMOR_MATERIALS.register(modEventBus);
        AotAItemRegistry.ITEMS.register(modEventBus);
        CREATIVE_MODE_TAB.register(modEventBus);
        CREATIVE_MODE_TAB.register("armoroftheages", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.armoroftheages")).icon(() -> ((Item)AotAItemRegistry.TAB_ICON.get()).getDefaultInstance()).displayItems((params, output) -> output.acceptAll(AotAItemRegistry.ITEMS.getEntries().stream().filter(holder -> holder != AotAItemRegistry.TAB_ICON).map(itemDeferredHolder -> ((Item)itemDeferredHolder.get()).getDefaultInstance()).toList())).build());
        if (dist.isClient()) {
            ArmorOfTheAgesClientNeoforge.setup(modEventBus);
        }
        CommonClass.init();
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("my_mod").versioned("1.2.3").optional();
        NeoforgeConfigSyncNetworkHandler handler = (NeoforgeConfigSyncNetworkHandler)CommonClass.CONFIG_SYNC_HANDLER;
        registrar.playToClient(S2CPreferenceSyncPacket.TYPE, S2CPreferenceSyncPacket.STREAM_CODEC, handler::handle);
        registrar.playToServer(C2SPreferenceSyncPacket.TYPE, C2SPreferenceSyncPacket.STREAM_CODEC, handler::handle);
        registrar.playToServer(C2SDisablePreferencesPacket.TYPE, StreamCodec.unit((Object)new C2SDisablePreferencesPacket()), handler::handle);
    }
}

