/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.MudBallProjectile;
import tech.alexnijjar.golemoverhaul.common.tags.ModItemTags;

public class TerracottaGolem
extends BaseGolem
implements IShearable,
RangedAttackMob {
    public static final int RANGED_ATTACK_DELAY_TICKS = 2;
    private static final EntityDataAccessor<Byte> ID_TYPE = SynchedEntityData.defineId(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f);
    private int attackAnimationDelay = -1;
    private ItemStack equippedStack = ItemStack.EMPTY;

    public TerracottaGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (double)Type.CACTUS.attackDamage);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnTerracottaGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_TYPE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("type", this.getTerracottaType().name().toLowerCase(Locale.ROOT));
        if (!this.equippedStack.isEmpty()) {
            compound.put("item", this.equippedStack.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTerracottaType(Type.valueOf(compound.getString("type").toUpperCase(Locale.ROOT)));
        if (compound.contains("item")) {
            this.equippedStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("item")).orElse(ItemStack.EMPTY);
        }
    }

    @Override
    public boolean canMeleeAttack() {
        return !this.getTerracottaType().ranged;
    }

    public Type getTerracottaType() {
        return Type.values()[(Byte)this.entityData.get(ID_TYPE)];
    }

    public void setTerracottaType(Type type) {
        this.entityData.set(ID_TYPE, (Object)((byte)type.ordinal()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)type.attackDamage);
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue((double)type.knockbackResistance);
        this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
        if (type.ranged) {
            this.goalSelector.addGoal(2, (Goal)this.rangedAttackGoal);
        }
        this.updateAttackGoals();
    }

    @Override
    public int getAttackTicks() {
        return 12;
    }

    @Override
    public Item getRepairItem() {
        return Items.CLAY;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 4.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setTerracottaType(Type.values()[level.getRandom().nextInt(Type.values().length)]);
        return super.finalizeSpawn(level, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        Type type;
        if (super.mobInteract(player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (this.getTerracottaType() == Type.NORMAL && (type = Type.ofStack(stack)) != null) {
            this.equippedStack = stack.copyWithCount(1);
            stack.shrink(1);
            this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value());
            this.setTerracottaType(type);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        this.playSound(SoundEvents.SNOW_GOLEM_SHEAR);
        this.setTerracottaType(Type.NORMAL);
        if (!this.equippedStack.isEmpty()) {
            return List.of(this.equippedStack);
        }
        return List.of(this.getTerracottaType().equipItem.getDefaultInstance());
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.getTerracottaType() != Type.NORMAL;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (!this.level().isClientSide() && this.getTerracottaType() == Type.CACTUS && !source.is(DamageTypes.THORNS) && (entity = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.hurt(this.damageSources().thorns((Entity)this), 6.0f);
        }
        return super.hurt(source, amount);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (this.attackAnimationDelay == -1) {
            this.sendAttackEvent();
            this.attackAnimationDelay = 2;
        }
    }

    public void actuallyShoot(LivingEntity target) {
        if (target == null) {
            return;
        }
        MudBallProjectile projectile = new MudBallProjectile(this.level(), (LivingEntity)this);
        projectile.setPos(this.getX(), this.getY(), this.getZ());
        double x = target.getX() - this.getX();
        double y = target.getY() - projectile.getY();
        double z = target.getZ() - this.getZ();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.shoot(x, y + distance, z, 1.0f, 5.0f);
        this.level().addFreshEntity((Entity)projectile);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    protected void customServerAiStep() {
        this.attackAnimationDelay = Math.max(-1, this.attackAnimationDelay - 1);
        if (this.attackAnimationDelay == 0) {
            this.actuallyShoot(this.getTarget());
            this.attackAnimationDelay = -1;
        }
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5, 0.0, 0.5);
    }

    public static enum Type {
        NORMAL(2.0f, 0.0f, Items.AIR, false, stack -> false),
        CACTUS(6.0f, 1.0f, Items.CACTUS, false, stack -> stack.is(ModItemTags.CACTUS)),
        DEAD_BUSH(4.0f, 0.0f, Items.DEAD_BUSH, true, stack -> stack.is(Items.DEAD_BUSH));

        private final float attackDamage;
        private final float knockbackResistance;
        private final Item equipItem;
        private final boolean ranged;
        private final Predicate<ItemStack> isValidStack;

        private Type(float attackDamage, float knockbackResistance, Item equipItem, boolean ranged, Predicate<ItemStack> isValidStack) {
            this.attackDamage = attackDamage;
            this.knockbackResistance = knockbackResistance;
            this.equipItem = equipItem;
            this.ranged = ranged;
            this.isValidStack = isValidStack;
        }

        @Nullable
        private static Type ofStack(ItemStack stack) {
            for (Type type : Type.values()) {
                if (!type.isValidStack.test(stack)) continue;
                return type;
            }
            return null;
        }
    }
}

