/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.AdditionalBeeData;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.HoneyBlobProjectile;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;
import tech.alexnijjar.golemoverhaul.mixins.common.BeeAccessor;

public class HoneyGolem
extends BaseGolem
implements RangedAttackMob,
IShearable {
    public static final byte NECTAR_PARTICLES_EVENT_ID = 8;
    public static final int RANGED_ATTACK_DELAY_TICKS = 6;
    public static final EntityDataAccessor<Byte> ID_HONEY_LEVEL = SynchedEntityData.defineId(HoneyGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final List<BeeData> bees = new ArrayList<BeeData>();
    private int attackAnimationDelay = -1;
    private boolean hasPopulatedInitialBees;

    public HoneyGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 8;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnHoneyGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_HONEY_LEVEL, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("HoneyLevel", this.getHoneyLevel());
        ListTag beeTag = new ListTag();
        for (BeeData bee : this.bees) {
            CompoundTag tag = new CompoundTag();
            tag.put("EntityData", (Tag)bee.tag);
            tag.putInt("TicksInHive", bee.ticks);
            tag.putInt("MinOccupationTicks", bee.minOccupationTicks);
            beeTag.add((Object)tag);
        }
        compound.put("Bees", (Tag)beeTag);
        compound.putBoolean("HasPopulatedInitialBees", this.hasPopulatedInitialBees);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHoneyLevel(compound.getByte("HoneyLevel"));
        ListTag beeTag = compound.getList("Bees", 10);
        for (int i = 0; i < beeTag.size(); ++i) {
            CompoundTag tag = beeTag.getCompound(i);
            this.bees.add(new BeeData(tag.getCompound("EntityData"), tag.getInt("TicksInHive"), tag.getInt("MinOccupationTicks")));
        }
        this.hasPopulatedInitialBees = compound.getBoolean("HasPopulatedInitialBees");
    }

    @Override
    public boolean canMeleeAttack() {
        return false;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f));
    }

    public byte getHoneyLevel() {
        return (Byte)this.entityData.get(ID_HONEY_LEVEL);
    }

    public void setHoneyLevel(byte honeyLevel) {
        this.entityData.set(ID_HONEY_LEVEL, (Object)honeyLevel);
    }

    public boolean isFullOfHoney() {
        return this.getHoneyLevel() >= 4;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.HONEY_BLOCK_HIT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.HONEY_BLOCK_BREAK;
    }

    @Override
    public int getAttackTicks() {
        return 15;
    }

    @Override
    public Item getRepairItem() {
        return Items.HONEY_BOTTLE;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 20.0f;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (this.attackAnimationDelay == -1) {
            this.sendAttackEvent();
            this.attackAnimationDelay = 6;
        }
    }

    public void actuallyShoot(LivingEntity target) {
        if (target == null) {
            return;
        }
        HoneyBlobProjectile projectile = new HoneyBlobProjectile(this.level(), (LivingEntity)this);
        projectile.setPos(this.getX(), this.getY(), this.getZ());
        double x = target.getX() - this.getX();
        double y = target.getY() - projectile.getY();
        double z = target.getZ() - this.getZ();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.shoot(x, y + distance + 0.8, z, 1.2f, 3.0f);
        this.level().addFreshEntity((Entity)projectile);
        this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && !this.hasPopulatedInitialBees) {
            this.hasPopulatedInitialBees = true;
            this.populateInitialBees();
        }
    }

    private void populateInitialBees() {
        int count = 2 + this.level().getRandom().nextInt(4);
        for (int i = 0; i < count; ++i) {
            Bee bee = Objects.requireNonNull((Bee)EntityType.BEE.create(this.level()));
            ((AdditionalBeeData)bee).golemoverhaul$setOwner(this.getUUID());
            this.bees.add(new BeeData(bee.saveWithoutId(new CompoundTag()), 0, 2400));
        }
        this.setHoneyLevel((byte)count);
    }

    protected void customServerAiStep() {
        if (!this.bees.isEmpty() && this.level().getRandom().nextDouble() < 0.005) {
            this.playSound(SoundEvents.BEEHIVE_WORK);
        }
        if (!this.level().isNight() && !this.level().isRaining()) {
            for (int i = 0; i < this.bees.size(); ++i) {
                BeeData bee = this.bees.get(i);
                ++bee.ticks;
                if (bee.ticks < bee.minOccupationTicks) continue;
                this.releaseBee(i);
                --i;
            }
        }
        if (!this.bees.isEmpty() && this.tickCount % 200 == 0) {
            this.heal(1.0f);
        }
        this.attackAnimationDelay = Math.max(-1, this.attackAnimationDelay - 1);
        if (this.attackAnimationDelay == 0) {
            this.actuallyShoot(this.getTarget());
            this.attackAnimationDelay = -1;
        }
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (this.level().isClientSide()) {
            return;
        }
        if (!this.bees.isEmpty()) {
            this.releaseAllBees();
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        if (!this.isFullOfHoney()) {
            return List.of();
        }
        this.playSound(SoundEvents.BEEHIVE_SHEAR);
        if (!this.level().isClientSide()) {
            this.setHoneyLevel((byte)0);
        }
        return List.of(new ItemStack((ItemLike)ModItems.HONEY_BLOB.get(), 5 + level.random.nextInt(8)), new ItemStack((ItemLike)Items.HONEYCOMB, 3));
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.isFullOfHoney();
    }

    @Override
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 8) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_NECTAR, this.getX() + this.getRandom().nextGaussian() * 0.25, this.getY() + 0.5, this.getZ() + this.getRandom().nextGaussian() * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public void healFromNectar() {
        this.heal(5.0f);
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (!this.bees.isEmpty() && (entity = source.getEntity()) instanceof LivingEntity) {
            Player player;
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2 instanceof Player && (player = (Player)entity2).isCreative()) {
                return super.hurt(source, amount);
            }
            this.releaseAllBees().forEach(bee -> bee.setTarget(entity2));
        }
        return super.hurt(source, amount);
    }

    public boolean canPutBee() {
        return this.bees.size() < 5;
    }

    public void putBee(Bee bee) {
        if (!this.canPutBee()) {
            return;
        }
        ((AdditionalBeeData)bee).golemoverhaul$setOwner(this.getUUID());
        this.bees.add(new BeeData(bee.saveWithoutId(new CompoundTag()), 0, 2400));
        if (bee.hasNectar() && !this.isFullOfHoney()) {
            this.setHoneyLevel((byte)(this.getHoneyLevel() + 1));
            if (this.getHealth() < this.getMaxHealth()) {
                this.heal(10.0f);
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
            }
        }
        bee.dropOffNectar();
        bee.discard();
        this.playSound(SoundEvents.BEEHIVE_ENTER);
    }

    private Bee releaseBee(int index) {
        BeeData data = this.bees.get(index);
        Bee bee = Objects.requireNonNull((Bee)EntityType.BEE.create(this.level()));
        bee.load(data.tag);
        bee.setPos(this.getX(), this.getY(), this.getZ());
        bee.dropOffNectar();
        bee.setHealth(bee.getMaxHealth());
        this.level().addFreshEntity((Entity)bee);
        bee.setStayOutOfHiveCountdown(400);
        this.playSound(SoundEvents.BEEHIVE_EXIT);
        this.bees.remove(index);
        return bee;
    }

    public List<Bee> releaseAllBees() {
        ArrayList<Bee> removedBees = new ArrayList<Bee>();
        int size = this.bees.size();
        for (int i = 0; i < size; ++i) {
            Bee bee = this.releaseBee(0);
            ((BeeAccessor)bee).setRemainingCooldownBeforeLocatingNewFlower(400);
            removedBees.add(bee);
        }
        return removedBees;
    }

    private static final class BeeData {
        private final CompoundTag tag;
        private int ticks;
        private final int minOccupationTicks;

        private BeeData(CompoundTag tag, int ticks, int minOccupationTicks) {
            this.tag = tag;
            this.ticks = ticks;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

