/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class HayGolem
extends BaseGolem
implements IShearable {
    private static final EntityDataAccessor<Byte> ID_COLOR = SynchedEntityData.defineId(HayGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_SHEARED = SynchedEntityData.defineId(HayGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public HayGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 8;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.18).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnHayGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)((RecipeHolder)level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (RecipeInput)new SingleEntityInput((EntityType)ModEntityTypes.HAY_GOLEM.get()), level).orElseThrow()).value();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().find((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        HayGolem golem = (HayGolem)((EntityType)ModEntityTypes.HAY_GOLEM.get()).create(level);
        if (golem == null) {
            return;
        }
        golem.setColor(level.getRandom().nextBoolean() ? Color.GREEN : Color.RED);
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.getBlock(1, 2, 0).getPos());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_COLOR, (Object)0);
        builder.define(ID_SHEARED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("color", this.getColor().name().toLowerCase(Locale.ROOT));
        compound.putBoolean("sheared", this.isSheared());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("color")) {
            this.setColor(Color.valueOf(compound.getString("color").toUpperCase(Locale.ROOT)));
        }
        this.setSheared(compound.getBoolean("sheared"));
    }

    @Override
    public boolean canTarget() {
        return false;
    }

    public Color getColor() {
        return Color.values()[(Byte)this.entityData.get(ID_COLOR)];
    }

    public void setColor(Color color) {
        this.entityData.set(ID_COLOR, (Object)((byte)color.ordinal()));
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(ID_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(ID_SHEARED, (Object)sheared);
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.HAY_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.HAY_GOLEM_DEATH.get();
    }

    @Override
    public Item getRepairItem() {
        return Items.WHEAT;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 10.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setColor(level.getRandom().nextBoolean() ? Color.GREEN : Color.RED);
        return super.finalizeSpawn(level, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5, 0.0, 0.5);
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        this.playSound(SoundEvents.SNOW_GOLEM_SHEAR);
        this.setSheared(true);
        return List.of(Items.CARVED_PUMPKIN.getDefaultInstance());
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return !this.isSheared();
    }

    public static enum Color {
        GREEN,
        RED;

    }
}

