/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;

public class BarrelGolem
extends BaseGolem {
    private static final EntityDataAccessor<Boolean> ID_OPEN = SynchedEntityData.defineId(BarrelGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ID_DAY_START_TICKS = SynchedEntityData.defineId(BarrelGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(2, 0, 2);
    public static final ResourceKey<LootTable> BARTERING_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"gameplay/barrel_golem_bartering"));
    public static final byte CHANGE_STATE_EVENT_ID = 8;
    public static final byte BARTER_EVENT_ID = 9;
    public static final int WAKE_UP_TICKS = 62;
    public static final int BARTERING_TICKS = 78;
    private int changeStateTicks;
    private int barteringTicks;
    private int openUpTicks;
    @Nullable
    private Player barteringTarget;

    public BarrelGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 10;
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.31).add(Attributes.ARMOR, 6.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnBarrelGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController((GeoAnimatable)this, "open_controller", 0, state -> {
            if (this.isBartering()) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            if (this.isWakingUp()) {
                return state.setAndContinue(ConstantAnimations.WAKE_UP);
            }
            if (this.openUpTicks > 0) {
                return state.setAndContinue(ConstantAnimations.OPEN);
            }
            if (this.level().isNight() || !this.isOpen()) {
                return state.setAndContinue(ConstantAnimations.HIDE);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "barter_controller", state -> {
            if (this.isBartering()) {
                return state.setAndContinue(ConstantAnimations.BARTER);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }));
    }

    @Override
    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        if (!this.isOpen()) {
            return PlayState.STOP;
        }
        if (this.isBartering()) {
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }
        return state.setAndContinue(moving ? ConstantAnimations.WALK : (this.isOpen() ? ConstantAnimations.IDLE : ConstantAnimations.IDLE_HIDDEN));
    }

    @Override
    public PlayState getAttackAnimation(AnimationState<? extends BaseGolem> state) {
        return PlayState.STOP;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_OPEN, (Object)true);
        builder.define(ID_DAY_START_TICKS, (Object)62);
    }

    public boolean canBeCollidedWith() {
        return this.isAlive() && !this.isOpen();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Open", this.isOpen());
        compound.putInt("ChangeStateTicks", this.changeStateTicks);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOpen(compound.getBoolean("Open"), false);
        this.changeStateTicks = compound.getInt("ChangeStateTicks");
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BarrelGolemPanicGoal(1.0));
        this.goalSelector.addGoal(2, (Goal)new BarrelGolemFindNearestEmeraldGoal());
    }

    @Override
    public boolean canTarget() {
        return false;
    }

    public boolean isOpen() {
        return (Boolean)this.entityData.get(ID_OPEN);
    }

    public boolean isBartering() {
        return this.barteringTicks > 0;
    }

    public int getBarteringTicks() {
        return this.barteringTicks;
    }

    public int getDayStartTicks() {
        return (Integer)this.entityData.get(ID_DAY_START_TICKS);
    }

    public void setDayStartTicks(int ticks) {
        this.entityData.set(ID_DAY_START_TICKS, (Object)ticks);
    }

    public void setOpen(boolean open, boolean playSound) {
        if (!open && this.isOnFire()) {
            return;
        }
        if (!this.level().isClientSide() && playSound && this.isOpen() != open) {
            if (open) {
                this.playSound(SoundEvents.BARREL_OPEN);
            } else {
                this.playSound(SoundEvents.BARREL_CLOSE);
            }
        }
        this.entityData.set(ID_OPEN, (Object)open);
        this.openUpTicks = open ? 10 : 0;
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(open ? 0.0 : 1.0);
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SHULKER_HURT_CLOSED;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR;
    }

    @Override
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 8) {
            this.changeStateTicks = this.getRandomChangeInterval();
        } else if (id == 9) {
            this.barteringTicks = 78;
        }
    }

    @Override
    public boolean canRepair(ItemStack stack) {
        return stack.is(ItemTags.PLANKS);
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setOpen(this.level().getSkyDarken() < 4, false);
        this.changeStateTicks = this.getRandomChangeInterval();
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.isOpen()) {
            AbstractArrow arrow;
            Entity entity = source.getDirectEntity();
            if (entity instanceof AbstractArrow && !(arrow = (AbstractArrow)entity).isOnFire()) {
                return false;
            }
            if (!source.is(DamageTypeTags.IS_FIRE)) {
                amount /= 10.0f;
            } else {
                amount *= 2.0f;
                if (!this.isOpen()) {
                    this.setOpen(true, true);
                }
            }
        }
        return super.hurt(source, amount);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            if (this.level().getSkyDarken() < 4) {
                this.setDayStartTicks(this.getDayStartTicks() + 1);
            } else {
                this.setDayStartTicks(0);
            }
        }
        this.changeStateTicks = Math.max(0, this.changeStateTicks - 1);
        this.barteringTicks = Math.max(0, this.barteringTicks - 1);
        this.openUpTicks = Math.max(0, this.openUpTicks - 1);
        if (!this.level().isClientSide()) {
            if (this.changeStateTicks == 0 && this.level().isDay() && !this.isWakingUp()) {
                this.setOpen(!this.isOpen(), true);
                this.changeStateTicks = this.getRandomChangeInterval();
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
            }
            if (!this.isOpen() || this.isBartering()) {
                this.navigation.stop();
            }
            if (!this.level().isDay() && this.isOpen()) {
                this.setOpen(false, true);
            } else if (this.finishedWakeUp() && !this.isOpen()) {
                this.setOpen(true, false);
            }
            if (this.barteringTicks == 24) {
                this.throwItems(this.getBarterResponseItems());
                ExperienceOrb orb = new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(2) + 2);
                this.level().addFreshEntity((Entity)orb);
                if (this.barteringTarget != null) {
                    Vec3 targetPos = this.barteringTarget.position().subtract(this.position());
                    targetPos = targetPos.normalize().multiply(0.3, 0.3, 0.3);
                    orb.setDeltaMovement(targetPos);
                }
                this.barteringTarget = null;
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.isOpen()) {
            this.setXRot(0.0f);
            this.yHeadRot = 0.0f;
            this.yBodyRot = 0.0f;
        }
        ItemStack stack = this.getMainHandItem();
        if (!this.level().isClientSide() && stack.is(Items.EMERALD) && !this.isBartering() && this.isOpen()) {
            this.barter();
        }
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        Entity entity;
        ItemStack stack = itemEntity.getItem();
        ItemStack equippedStack = this.equipItemIfPossible(stack.copy());
        if (!equippedStack.isEmpty()) {
            this.onItemPickup(itemEntity);
            this.take((Entity)itemEntity, 1);
            stack.shrink(1);
            if (stack.isEmpty()) {
                itemEntity.discard();
            } else {
                itemEntity.setExtendedLifetime();
            }
        }
        if ((entity = itemEntity.getOwner()) instanceof Player) {
            Player player;
            this.barteringTarget = player = (Player)entity;
        }
    }

    public boolean wantsToPickUp(ItemStack stack) {
        return this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && stack.is(Items.EMERALD) && this.getMainHandItem().isEmpty() && this.isOpen() && !this.isBartering();
    }

    @NotNull
    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    public boolean isWakingUp() {
        int ticks = this.getDayStartTicks();
        return ticks > 0 && ticks < 62;
    }

    private boolean finishedWakeUp() {
        return this.getDayStartTicks() == 62;
    }

    private int getRandomChangeInterval() {
        return 800 + this.getRandom().nextInt(800);
    }

    public void barter() {
        if (this.isBartering()) {
            return;
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
        this.changeStateTicks = this.getRandomChangeInterval();
        this.barteringTicks = 78;
        this.playSound((SoundEvent)ModSoundEvents.BARREL_GOLEM_BARTER.get());
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.level().isClientSide() && this.wantsToPickUp(stack)) {
            this.barteringTarget = player;
            this.setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private List<ItemStack> getBarterResponseItems() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LootTable lootTable = level2.getServer().reloadableRegistries().getLootTable(BARTERING_LOOT);
            return lootTable.getRandomItems(new LootParams.Builder(level2).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.PIGLIN_BARTER));
        }
        return List.of();
    }

    private void throwItems(List<ItemStack> stacks) {
        if (this.barteringTarget != null) {
            this.throwItemsTowardPlayer(this.barteringTarget, stacks);
        } else {
            this.throwItemsTowardRandomPos(stacks);
        }
    }

    private void throwItemsTowardRandomPos(List<ItemStack> stacks) {
        this.throwItemsTowardPos(stacks, this.getRandomNearbyPos());
    }

    private void throwItemsTowardPlayer(Player player, List<ItemStack> stacks) {
        this.throwItemsTowardPos(stacks, player.position());
    }

    private void throwItemsTowardPos(List<ItemStack> stacks, Vec3 pos) {
        for (ItemStack stack : stacks) {
            BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)stack, (Vec3)pos.add(0.0, 1.0, 0.0));
        }
    }

    private Vec3 getRandomNearbyPos() {
        Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this, (int)4, (int)2);
        return vec3 == null ? this.position() : vec3;
    }

    private class BarrelGolemPanicGoal
    extends PanicGoal {
        public BarrelGolemPanicGoal(double speedModifier) {
            super((PathfinderMob)BarrelGolem.this, speedModifier);
        }

        public boolean canUse() {
            return BarrelGolem.this.isOpen() && super.canUse();
        }

        public void stop() {
            super.stop();
            BarrelGolem.this.setOpen(false, true);
        }
    }

    private class BarrelGolemFindNearestEmeraldGoal
    extends Goal {
        private ItemEntity nearest;

        private BarrelGolemFindNearestEmeraldGoal() {
        }

        public boolean canUse() {
            ItemEntity nearest;
            if (BarrelGolem.this.isOpen() && !BarrelGolem.this.isBartering() && (nearest = (ItemEntity)BarrelGolem.this.level().getEntitiesOfClass(ItemEntity.class, BarrelGolem.this.getBoundingBox().inflate(16.0), stack -> stack.getItem().is(Items.EMERALD)).stream().findFirst().orElse(null)) != null) {
                this.nearest = nearest;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return BarrelGolem.this.isOpen() && !BarrelGolem.this.isBartering() && this.nearest != null && !this.nearest.isRemoved();
        }

        public void tick() {
            BarrelGolem.this.navigation.moveTo((Entity)this.nearest, 0.7);
            BarrelGolem.this.lookControl.setLookAt((Entity)this.nearest, 30.0f, 30.0f);
        }
    }
}

