/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.goals;

import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.entities.AdditionalBeeData;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HoneyGolem;
import tech.alexnijjar.golemoverhaul.mixins.common.BeeAccessor;

public class GoToHoneyGolemHiveGoal
extends Goal {
    private final Bee bee;
    private final BeeAccessor beeAccessor;
    private int travellingTicks;
    @Nullable
    private HoneyGolem hive;

    public GoToHoneyGolemHiveGoal(Bee bee) {
        this.bee = bee;
        this.beeAccessor = (BeeAccessor)bee;
        bee.level().random.nextInt(10);
    }

    public boolean canUse() {
        if (!this.bee.isAngry() && !this.bee.hasRestriction() && this.beeAccessor.invokeWantsToEnterHive()) {
            HoneyGolem golem = this.hive == null ? this.findHive() : this.hive;
            return golem != null && !golem.isDeadOrDying() && golem.canPutBee();
        }
        return false;
    }

    public void start() {
        this.travellingTicks = 0;
        this.hive = this.findHive();
    }

    public void stop() {
        this.travellingTicks = 0;
        this.bee.getNavigation().stop();
        this.bee.getNavigation().resetMaxVisitedNodesMultiplier();
        this.hive = null;
    }

    public void tick() {
        if (this.hive == null) {
            return;
        }
        if (this.bee.distanceTo((Entity)this.hive) < 2.0f) {
            this.hive.putBee(this.bee);
            this.stop();
        } else {
            ++this.travellingTicks;
            if (this.travellingTicks > this.adjustedTickDelay(600)) {
                this.stop();
            } else {
                this.bee.getNavigation().moveTo((Entity)this.hive, 1.0);
            }
        }
    }

    @Nullable
    private HoneyGolem findHive() {
        ServerLevel level;
        Entity entity;
        Level level2;
        UUID owner = ((AdditionalBeeData)this.bee).golemoverhaul$getOwner();
        if (owner != null && (level2 = this.bee.level()) instanceof ServerLevel && (entity = (level = (ServerLevel)level2).getEntity(owner)) instanceof HoneyGolem) {
            HoneyGolem golem = (HoneyGolem)entity;
            return golem;
        }
        return null;
    }
}

