/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.loot_tables;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

public class ArmorSlotFunction
extends LootItemConditionalFunction {
    final EquipmentSlot slot;
    public static final MapCodec<ArmorSlotFunction> CODEC = RecordCodecBuilder.mapCodec(p_298087_ -> ArmorSlotFunction.commonFields((RecordCodecBuilder.Instance)p_298087_).and((App)EquipmentSlot.CODEC.fieldOf("slot").forGetter(p_298086_ -> p_298086_.slot)).apply((Applicative)p_298087_, ArmorSlotFunction::new));

    ArmorSlotFunction(List<LootItemCondition> pConditions, EquipmentSlot slot) {
        super(pConditions);
        this.slot = slot;
    }

    protected ItemStack run(ItemStack pStack, LootContext pContext) {
        LivingEntity livingEntity = (LivingEntity)pContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!livingEntity.hasItemInSlot(this.slot)) {
            livingEntity.setItemSlot(this.slot, pStack);
        }
        return pStack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)IWALootTables.ARMOR_SLOT.get();
    }

    public static LootItemConditionalFunction.Builder<?> armorSlotFunction(EquipmentSlot slot) {
        return ArmorSlotFunction.simpleBuilder(conditions -> new ArmorSlotFunction((List<LootItemCondition>)conditions, slot));
    }
}

