/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.common.data;

import com.kekecreations.jinxedlib.common.data.Compostables;
import com.kekecreations.jinxedlib.core.registry.JinxedDatapackRegistries;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;

public class CompostableUtils {
    public static Float getCompostableValue(RegistryAccess access, ItemStack stack) {
        Optional<Compostables> optionalPalette = access.registryOrThrow(JinxedDatapackRegistries.COMPOSTABLES).stream().filter(searchPalette -> searchPalette.values().containsKey(stack.getItemHolder())).findFirst();
        if (optionalPalette.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        Compostables palette = optionalPalette.get();
        Float holder = palette.values().get(stack.getItemHolder());
        if (holder.isNaN()) {
            return Float.valueOf(0.0f);
        }
        return holder;
    }

    public static boolean isItemCompostable(RegistryAccess access, ItemStack stack) {
        Optional<Compostables> optionalPalette = access.registryOrThrow(JinxedDatapackRegistries.COMPOSTABLES).stream().filter(searchPalette -> searchPalette.values().containsKey(stack.getItemHolder())).findFirst();
        return optionalPalette.isPresent();
    }

    public static boolean canVillagerCompost(RegistryAccess access, ItemStack stack) {
        Optional<Compostables> optionalPalette = access.registryOrThrow(JinxedDatapackRegistries.COMPOSTABLES).stream().filter(Compostables::canVillagerCompost).findFirst();
        return optionalPalette.stream().anyMatch(searchPalette -> searchPalette.values().containsKey(stack.getItemHolder()));
    }
}

