/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.client.renderer.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.kekecreations.jinxedlib.core.registry.JinxedSpriteSources;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class JinxedPalettedPermutations
implements SpriteSource {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<JinxedPalettedPermutations> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)SpriteSources.CODEC).fieldOf("sources").forGetter(palettedPermutations -> palettedPermutations.sources), (App)ResourceLocation.CODEC.fieldOf("palette_key").forGetter(palettedPermutations -> palettedPermutations.paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.CODEC).fieldOf("permutations").forGetter(palettedPermutations -> palettedPermutations.permutations)).apply((Applicative)instance, JinxedPalettedPermutations::new));
    private final List<SpriteSource> sources;
    private final Map<String, ResourceLocation> permutations;
    private final ResourceLocation paletteKey;

    private JinxedPalettedPermutations(List<SpriteSource> list, ResourceLocation resourceLocation, Map<String, ResourceLocation> map) {
        this.sources = list;
        this.permutations = map;
        this.paletteKey = resourceLocation;
    }

    public void run(@NotNull ResourceManager resourceManager, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SpriteSource.Output output) {
        Supplier supplier = Suppliers.memoize(() -> JinxedPalettedPermutations.loadPaletteEntryFromImage(resourceManager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> JinxedPalettedPermutations.lambda$run$6(map, (java.util.function.Supplier)supplier, resourceManager, arg_0, arg_1));
        final HashMap sourceOutputMap = new HashMap();
        SpriteSource.Output sourceOutput = new SpriteSource.Output(){

            public void add(@NotNull ResourceLocation location, @NotNull SpriteSource.SpriteSupplier spriteSupplier) {
                SpriteSource.SpriteSupplier supplier = sourceOutputMap.put(location, spriteSupplier);
                if (supplier != null) {
                    supplier.discard();
                }
            }

            public void removeAll(@NotNull Predicate<ResourceLocation> predicate) {
                Iterator iterator = sourceOutputMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!predicate.test((ResourceLocation)entry.getKey())) continue;
                    ((SpriteSource.SpriteSupplier)entry.getValue()).discard();
                    iterator.remove();
                }
            }
        };
        for (SpriteSource source : this.sources) {
            source.run(resourceManager, sourceOutput);
        }
        for (ResourceLocation resourceLocation : sourceOutputMap.keySet()) {
            ResourceLocation resourceLocation2 = TEXTURE_ID_CONVERTER.idToFile(resourceLocation);
            Optional optional = resourceManager.getResource(resourceLocation2);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourceLocation2);
                continue;
            }
            LazyLoadedImage lazyLoadedImage = new LazyLoadedImage(resourceLocation2, (Resource)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation resourceLocation3 = resourceLocation.withSuffix("_" + (String)entry.getKey());
                output.add(resourceLocation3, (SpriteSource.SpriteSupplier)new JinxedPalettedSpriteSupplier(lazyLoadedImage, (java.util.function.Supplier)entry.getValue(), resourceLocation3));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] is, int[] js) {
        if (js.length != is.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)is.length, (Object)js.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2IntMap = new Int2IntOpenHashMap(js.length);
        for (int i = 0; i < is.length; ++i) {
            int j = is[i];
            if (FastColor.ABGR32.alpha((int)j) == 0) continue;
            int2IntMap.put(FastColor.ABGR32.transparent((int)j), js[i]);
        }
        return arg_0 -> JinxedPalettedPermutations.lambda$createPaletteMapping$7((Int2IntMap)int2IntMap, arg_0);
    }

    public static int[] loadPaletteEntryFromImage(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Optional optional = resourceManager.getResource(TEXTURE_ID_CONVERTER.idToFile(resourceLocation));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)resourceLocation);
            throw new IllegalArgumentException();
        }
        try {
            int[] var5;
            try (InputStream inputStream = ((Resource)optional.get()).open();
                 NativeImage nativeImage = NativeImage.read((InputStream)inputStream);){
                var5 = nativeImage.getPixelsRGBA();
            }
            return var5;
        }
        catch (Exception var11) {
            Exception exception = var11;
            LOGGER.error("Couldn't load texture {}", (Object)resourceLocation, (Object)exception);
            throw new IllegalArgumentException();
        }
    }

    public SpriteSourceType type() {
        return JinxedSpriteSources.PALETTED_PERMUTATIONS;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$7(Int2IntMap int2IntMap, int ix) {
        int j = FastColor.ABGR32.alpha((int)ix);
        if (j == 0) {
            return ix;
        }
        int k = FastColor.ABGR32.transparent((int)ix);
        int l = int2IntMap.getOrDefault(k, FastColor.ABGR32.opaque((int)k));
        int m = FastColor.ABGR32.alpha((int)l);
        return FastColor.ABGR32.color((int)(j * m / 255), (int)l);
    }

    private static /* synthetic */ void lambda$run$6(Map map, java.util.function.Supplier supplier, ResourceManager resourceManager, String string, ResourceLocation resourceLocationx) {
        map.put(string, Suppliers.memoize(() -> JinxedPalettedPermutations.lambda$run$5((java.util.function.Supplier)supplier, resourceManager, resourceLocationx)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$5(java.util.function.Supplier supplier, ResourceManager resourceManager, ResourceLocation resourceLocationx) {
        return JinxedPalettedPermutations.createPaletteMapping((int[])supplier.get(), JinxedPalettedPermutations.loadPaletteEntryFromImage(resourceManager, resourceLocationx));
    }

    record JinxedPalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> paletteSupplier, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public SpriteContents apply(SpriteResourceLoader loader) {
            SpriteContents var2;
            try {
                SpriteContents var22;
                NativeImage nativeImage = this.baseImage.get().mappedCopy(this.paletteSupplier.get());
                SpriteContents spriteContents = var22 = new SpriteContents(this.permutationLocation, new FrameSize(nativeImage.getWidth(), nativeImage.getHeight()), nativeImage, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException var6) {
                Exception exception = var6;
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)exception);
                var2 = null;
            }
            finally {
                this.baseImage.release();
            }
            return var2;
        }

        public void discard() {
            this.baseImage.release();
        }

        public java.util.function.Supplier<IntUnaryOperator> palette() {
            return this.paletteSupplier;
        }
    }
}

