/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public interface ISourceNode
extends IElectricityNode {
    public static final AABB DEFAULT_NODE_BOX = new AABB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);

    public void setNodeOverloaded(boolean var1);

    public boolean isNodeOverloaded();

    default public void onNodeOverloaded() {
    }

    default public int getMaxPowerableNodes() {
        return (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
    }

    @Override
    default public boolean isSourceNode() {
        return true;
    }

    @Override
    default public boolean canPowerTraverseNode() {
        return false;
    }

    @Override
    default public AABB getNodeInteractBox() {
        return DEFAULT_NODE_BOX;
    }

    @Override
    default public void setNodeReceivingPower(boolean state) {
    }

    @Override
    default public boolean isNodeReceivingPower() {
        return false;
    }

    @Override
    default public Set<BlockPos> getPowerSources() {
        return new HashSet<BlockPos>(Collections.singleton(this.getNodePosition()));
    }

    @Override
    default public boolean isNodeInPowerableNetwork(BlockPos source) {
        return true;
    }

    @Override
    default public void readNodeNbt(CompoundTag tag) {
        IElectricityNode.super.readNodeNbt(tag);
        this.setNodeOverloaded(tag.getBoolean("Overloaded"));
    }

    @Override
    default public void writeNodeNbt(CompoundTag tag) {
        IElectricityNode.super.writeNodeNbt(tag);
        tag.putBoolean("Overloaded", this.isNodeOverloaded());
    }

    @Override
    default public void earlyNodeTick(Level level) {
        if (!level.isClientSide()) {
            if (this.isNodePowered() && !this.isNodeOverloaded()) {
                NodeSearchResult result = this.searchNodeNetwork(false);
                if (result.overloaded()) {
                    this.setNodeOverloaded(true);
                    this.onNodeOverloaded();
                    return;
                }
                result.nodes().forEach(node -> node.setNodeReceivingPower(true));
            }
        } else {
            NodeSearchResult result = this.searchNodeNetwork(true);
            result.nodes().forEach(node -> node.getPowerSources().add(this.getNodePosition()));
        }
    }

    default public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        List<IElectricityNode> nodes = IElectricityNode.searchNodes(this, this.getMaxPowerableNodes(), cancelAtLimit, node -> !node.isSourceNode() && node.canPowerTraverseNode(), node -> !node.isSourceNode());
        boolean overloaded = nodes.size() > this.getMaxPowerableNodes();
        return new NodeSearchResult(overloaded, nodes);
    }

    public static AABB createPowerableZone(Level level, BlockPos pos) {
        double radius = ((Integer)Config.SERVER.electricity.powerableAreaRadius.get()).intValue();
        double minX = (double)pos.getX() - radius;
        double minY = (double)pos.getY() - radius;
        double minZ = (double)pos.getZ() - radius;
        double maxX = (double)pos.getX() + radius + 1.0;
        double maxY = (double)pos.getY() + radius + 1.0;
        double maxZ = (double)pos.getZ() + radius + 1.0;
        minY = Math.max(minY, (double)level.getMinBuildHeight());
        maxY = Math.min(maxY, (double)level.getMaxBuildHeight());
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

