/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.furniture.refurbished.Bootstrap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.FurnitureBlockTagsProvider;
import com.mrcrayfish.furniture.refurbished.data.FurnitureItemTagsProvider;
import com.mrcrayfish.furniture.refurbished.data.FurnitureLootTableProvider;
import com.mrcrayfish.furniture.refurbished.data.FurnitureModelProvider;
import com.mrcrayfish.furniture.refurbished.data.FurnitureRecipeProvider;
import com.mrcrayfish.furniture.refurbished.data.RegistriesProvider;
import com.mrcrayfish.furniture.refurbished.platform.NeoForgeFluidHelper;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@Mod(value="refurbished_furniture")
public class FurnitureMod {
    public FurnitureMod(IEventBus bus) {
        NeoForgeMod.enableMilkFluid();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onGatherData);
        bus.addListener(this::onRegisterCapabilities);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Bootstrap::init);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        FurnitureBlockTagsProvider blockTagsProvider = (FurnitureBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new FurnitureBlockTagsProvider(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new FurnitureItemTagsProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new FurnitureLootTableProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new FurnitureRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, RegistriesProvider.BUILDER, Set.of("refurbished_furniture")));
        generator.addProvider(event.includeClient(), (DataProvider)new FurnitureModelProvider(output, helper));
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.FREEZER.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper((WorldlyContainer)entity, Direction.DOWN) : new InvWrapper((Container)entity));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.STOVE.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper(entity.getContainer(), Direction.DOWN) : new InvWrapper((Container)entity));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.RECYCLE_BIN.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper((WorldlyContainer)entity, Direction.DOWN) : new SidedInvWrapper((WorldlyContainer)entity, Direction.UP));
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.BATH.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.KITCHEN_SINK.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.BASIN.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.TOILET.get());
    }

    private <T extends BlockEntity> void registerFluidHandler(RegisterCapabilitiesEvent event, BlockEntityType<T> type) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, type, (entity, context) -> {
            FluidContainer container = ((IFluidContainerBlock)entity).getFluidContainer();
            return container != null ? ((NeoForgeFluidHelper.NeoForgeFluidContainer)container).getTank() : EmptyFluidHandler.INSTANCE;
        });
    }
}

