/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.recipes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public class ZincMechanismRecipe {
    private boolean isFileEmpty(File file) {
        try {
            return Files.size(file.toPath()) == 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generateFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void ZincMechanismRecipeShaped(File folder) {
        File file = new File(folder, "ZincMechanismRecipeShaped.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.shaped(\n       Item.of('createmechanisms:zinc_mechanism', 1), // arg 1: output\n       [\n           'aba', // arg 2: the shape (array of strings)\n           ' c '\n       ],\n       {\n           a: 'create:zinc_ingot',\n           b: 'createmechanisms:wooden_mechanism',  //arg 3: the mapping object\n           c: 'create:iron_sheet'\n       }\n   )\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void ZincMechanismRecipeSequencial(File folder) {
        File file = new File(folder, "ZincMechanismRecipeSequencial.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.custom({\n       \"type\": \"create:sequenced_assembly\",\n       \"ingredient\": {\n           \"item\": \"create:iron_sheet\"\n       },\n       \"loops\": 3,\n       \"results\": [\n           {\n               \"chance\": 1.0,\n               \"item\": {\n                   \"id\": \"createmechanisms:zinc_mechanism\"\n               }\n           }\n       ],\n       \"sequence\": [\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:incomplete_zinc_mechanism\" },\n                   { \"item\": \"create:large_cogwheel\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_zinc_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:incomplete_zinc_mechanism\" },\n                   { \"item\": \"create:cogwheel\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_zinc_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:incomplete_zinc_mechanism\" },\n                   { \"item\": \"create:zinc_nugget\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_zinc_mechanism\"\n                       }\n                   }\n               ]\n           }\n       ],\n       \"transitional_item\": {\n           \"item\": {\n               \"id\": \"createmechanisms:incomplete_zinc_mechanism\"\n           },\n           \"amount\": 1\n       }\n   })\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

