/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.recipes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public class SawRecipe {
    private boolean isFileEmpty(File file) {
        try {
            return Files.size(file.toPath()) == 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generateFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void CopperSawRecipe(File folder) {
        File file = new File(folder, "CopperSawRecipe.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.shaped(\n       Item.of('createmechanisms:copper_saw', 1), // arg 1: output\n       [\n           '  c',\n           ' cb', // arg 2: the shape (array of strings)\n           'ab '\n       ],\n       {\n           a: '#minecraft:planks',\n           b: '#c:ingots/copper',\n           c: 'minecraft:stick'       }\n   )\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void IronSawRecipe(File folder) {
        File file = new File(folder, "IronSawRecipe.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.shaped(\n       Item.of('createmechanisms:iron_saw', 1), // arg 1: output\n       [\n           '  c',\n           ' cb', // arg 2: the shape (array of strings)\n           'ab '\n       ],\n       {\n           a: '#minecraft:planks',\n           b: '#c:ingots/iron',\n           c: 'minecraft:stick'       }\n   )\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void DiamondSawRecipe(File folder) {
        File file = new File(folder, "DiamondSawRecipe.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.shaped(\n       Item.of('createmechanisms:diamond_saw', 1), // arg 1: output\n       [\n           '  c',\n           ' cb', // arg 2: the shape (array of strings)\n           'ab '\n       ],\n       {\n           a: '#minecraft:planks',\n           b: '#c:gems/diamond',\n           c: 'minecraft:stick'       }\n   )\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

