/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.recipes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public class RubberRecipe {
    private boolean isFileEmpty(File file) {
        try {
            return Files.size(file.toPath()) == 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generateFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void RubberRecipe(File folder) {
        File file = new File(folder, "RubberRecipe.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.custom({\n       \"type\": \"create:mixing\",\n       \"ingredients\": [\n           {\n               \"item\": \"minecraft:kelp\"\n           },\n           {\n               \"item\": \"minecraft:kelp\"\n           },\n           {\n               \"item\": \"minecraft:kelp\"\n           },\n           {\n               \"item\": \"minecraft:kelp\"\n           },\n           {\n               \"type\": \"fluid_stack\",\n               \"amount\": 250,\n               \"fluid\": \"minecraft:water\"\n           }\n       ],\n       \"results\": [\n           {\n               \"chance\": 1.0,\n               \"item\": {\n                   \"id\": \"createmechanisms:rubber\"\n               },\n               \"amount\": 1\n           }\n       ]\n   })\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void CuredRubberRecipe(File folder) {
        File file = new File(folder, "CuredRubberRecipe.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.custom(\n       {\n           \"type\": \"minecraft:smelting\",\n           \"category\": \"misc\",\n           \"cookingtime\": 200,\n           \"experience\": 0.25,\n           \"ingredient\": {\n               \"item\": \"createmechanisms:rubber\"\n           },\n           \"result\": {\n               \"count\": 1,\n               \"id\": \"createmechanisms:cured_rubber\"\n           }\n       }\n   )\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

