/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.recipes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public class EnderMechanismRecipe {
    private boolean isFileEmpty(File file) {
        try {
            return Files.size(file.toPath()) == 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generateFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void EnderMechanismRecipeSequencial(File folder) {
        File file = new File(folder, "EnderMechanismRecipeSequencial.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.custom({\n       \"type\": \"create:sequenced_assembly\",\n       \"ingredient\": {\n           \"item\": \"createmechanisms:advanced_precision_mechanism\"\n       },\n       \"loops\": 10,\n       \"results\": [\n           {\n               \"chance\": 1.0,\n               \"item\": {\n                   \"id\": \"createmechanisms:ender_mechanism\"\n               }\n           }\n       ],\n       \"sequence\": [\n           {\n               \"type\": \"create:filling\",\n               \"ingredients\": [\n                   {\n                       \"item\": \"createmechanisms:incomplete_ender_mechanism\"\n                   },\n                   {\n                       \"type\": \"fluid_stack\",\n                       \"amount\": 200,\n                       \"fluid\": \"createmechanisms:enderiam\"\n                   }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_ender_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:pressing\",\n               \"ingredients\": [\n                   {\n                       \"item\": \"createmechanisms:incomplete_ender_mechanism\"\n                   }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_ender_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:incomplete_ender_mechanism\" },\n                   { \"item\": \"create:powdered_obsidian\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_ender_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:incomplete_ender_mechanism\" },\n                   { \"item\": \"ae2:ender_dust\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:incomplete_ender_mechanism\"\n                       }\n                   }\n               ]\n           }\n       ],\n       \"transitional_item\": {\n           \"item\": {\n               \"id\": \"createmechanisms:incomplete_ender_mechanism\"\n           },\n           \"amount\": 1\n       }\n   })\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

