/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.recipes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public class ComputingMechanismRecipe {
    private boolean isFileEmpty(File file) {
        try {
            return Files.size(file.toPath()) == 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generateFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void ComputingMechanismRecipeSequencial(File folder) {
        File file = new File(folder, "ComputingMechanismRecipeSequencial.js");
        this.generateFile(file);
        if (this.isFileEmpty(file)) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write("ServerEvents.recipes(event => {\n   event.custom({\n       \"type\": \"create:sequenced_assembly\",\n       \"ingredient\": {\n           \"item\": \"createmechanisms:zinc_mechanism\"\n       },\n       \"loops\": 3,\n       \"results\": [\n           {\n               \"chance\": 1.0,\n               \"item\": {\n                   \"id\": \"createmechanisms:computing_mechanism\"\n               }\n           }\n       ],\n       \"sequence\": [\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:computing_mechanism\" },\n                   { \"item\": \"ae2:logic_processor\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:computing_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:computing_mechanism\" },\n                   { \"item\": \"ae2:calculation_processor\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:computing_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:deploying\",\n               \"ingredients\": [\n                   { \"item\": \"createmechanisms:computing_mechanism\" },\n                   { \"item\": \"ae2:engineering_processor\" }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:computing_mechanism\"\n                       }\n                   }\n               ]\n           },\n           {\n               \"type\": \"create:pressing\",\n               \"ingredients\": [\n                   {\n                       \"item\": \"createmechanisms:computing_mechanism\"\n                   }\n               ],\n               \"results\": [\n                   {\n                       \"item\": {\n                           \"id\": \"createmechanisms:computing_mechanism\"\n                       }\n                   }\n               ]\n           }\n       ],\n       \"transitional_item\": {\n           \"item\": {\n               \"id\": \"createmechanisms:computing_mechanism\"\n           },\n           \"amount\": 1\n       }\n   })\n})");
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

