/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.item.custom;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.MaouGaukken.CreateMechanisms.init.ModToolTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SawItem
extends AxeItem {
    public SawItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    private int getMaxBlocks(Tier tier) {
        if (tier == ModToolTiers.COPPER) {
            return 20;
        }
        if (tier == ModToolTiers.MODIFIED_IRON) {
            return 64;
        }
        if (tier == ModToolTiers.MODIFIED_DIAMOND) {
            return 128;
        }
        return 10;
    }

    public boolean mineBlock(ItemStack itemInHand, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (level.isClientSide() || !(miningEntity instanceof Player)) {
            return true;
        }
        Player player = (Player)miningEntity;
        if (this.isLog(state)) {
            ServerLevel serverLevel = (ServerLevel)level;
            int maxBlocks = this.getMaxBlocks(((AxeItem)itemInHand.getItem()).getTier());
            int[] results = this.scanTree(serverLevel, pos, maxBlocks);
            int woodFound = results[0];
            int leavesFound = results[1];
            int woodBroken = 0;
            int leavesPassed = 0;
            if (leavesFound >= 10) {
                results = this.destroyTree(serverLevel, pos, maxBlocks);
                woodBroken = results[0];
                leavesPassed = results[1];
                player.displayClientMessage((Component)Component.literal((String)("Wood broken: " + woodBroken + " | Leaves found: " + leavesPassed)), true);
                if (!player.isCreative()) {
                    itemInHand.hurtAndBreak(woodBroken, (LivingEntity)player, null);
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)("Wood broken: " + ++woodBroken + " | Leaves found: " + leavesPassed)), true);
            }
        }
        return true;
    }

    private int[] scanTree(ServerLevel level, BlockPos startingPos, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startingPos);
        int woodCount = 0;
        int leafCount = 0;
        HashSet<BlockPos> possibleConnections = new HashSet<BlockPos>();
        while (!queue.isEmpty() && woodCount < maxBlocks) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.getBlockState(currentPos);
            if (!this.isLog(currentState) || !visited.add(currentPos)) continue;
            ++woodCount;
            for (BlockPos adjacent : this.getSurroundingBlocks(currentPos)) {
                BlockState adjacentState = level.getBlockState(adjacent);
                if (this.isLog(adjacentState)) {
                    queue.add(adjacent);
                    continue;
                }
                if (!this.isLeaf(adjacentState) || !visited.add(adjacent)) continue;
                queue.add(adjacent);
                ++leafCount;
                possibleConnections.add(adjacent);
            }
        }
        return new int[]{woodCount, leafCount};
    }

    private int[] destroyTree(ServerLevel level, BlockPos startingPos, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startingPos);
        int woodCount = 0;
        int leafCount = 0;
        while (!queue.isEmpty() && woodCount < maxBlocks) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.getBlockState(currentPos);
            if (!this.isLog(currentState) || !visited.add(currentPos)) continue;
            level.destroyBlock(currentPos, true);
            ++woodCount;
            for (BlockPos adjacent : this.getSurroundingBlocks(currentPos)) {
                BlockState adjacentState = level.getBlockState(adjacent);
                if (this.isLog(adjacentState)) {
                    queue.add(adjacent);
                    continue;
                }
                if (!this.isLeaf(adjacentState) || !visited.add(adjacent)) continue;
                queue.add(adjacent);
                ++leafCount;
            }
        }
        return new int[]{woodCount, leafCount};
    }

    private Set<BlockPos> getSurroundingBlocks(BlockPos pos) {
        return Set.of(pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west(), pos.north().above(), pos.north().below(), pos.south().above(), pos.south().below(), pos.east().above(), pos.east().below(), pos.west().above(), pos.west().below(), pos.north().east(), pos.north().west(), pos.south().east(), pos.south().west());
    }

    private boolean isLog(BlockState state) {
        return state.is(BlockTags.LOGS);
    }

    private boolean isLeaf(BlockState state) {
        return state.is(BlockTags.LEAVES);
    }
}

