/*
 * Decompiled with CFR 0.152.
 */
package net.MaouGaukken.CreateMechanisms.init;

import java.io.File;
import net.MaouGaukken.CreateMechanisms.recipes.AdvancedPrecisionMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.BronzeRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.ComputingMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.EnderDustRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.EnderMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.EnderiamRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.HeatMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.RubberMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.RubberRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.SawRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.WoodenMechanismRecipe;
import net.MaouGaukken.CreateMechanisms.recipes.ZincMechanismRecipe;

public class CreateDirectories {
    public void createDirectories(boolean generateRecipes) {
        File gameDirectory = new File(".");
        File baseFolder = new File(gameDirectory, "kubejs/server_scripts/CreateMechanisms/Base");
        File Ae2DependenciesFolder = new File(gameDirectory, "kubejs/server_scripts/CreateMechanisms/Ae2Dependencies");
        if (!Ae2DependenciesFolder.exists()) {
            Ae2DependenciesFolder.mkdirs();
        }
        if (!baseFolder.exists()) {
            baseFolder.mkdirs();
        }
        if (!generateRecipes) {
            this.deleteFolder(Ae2DependenciesFolder);
            this.deleteFolder(baseFolder);
            return;
        }
        WoodenMechanismRecipe WOODEN_MECHANISM = new WoodenMechanismRecipe();
        RubberMechanismRecipe RUBBER_MECHANISM = new RubberMechanismRecipe();
        ZincMechanismRecipe ZINC_MECHANISM = new ZincMechanismRecipe();
        HeatMechanismRecipe HEAT_MECHANISM = new HeatMechanismRecipe();
        ComputingMechanismRecipe COMPUTING_MECHANISM = new ComputingMechanismRecipe();
        AdvancedPrecisionMechanismRecipe ADVANCED_PRECISION_MECHANISM = new AdvancedPrecisionMechanismRecipe();
        EnderMechanismRecipe ENDER_MECHANISM = new EnderMechanismRecipe();
        RubberRecipe RUBBER = new RubberRecipe();
        BronzeRecipe BRONZE = new BronzeRecipe();
        EnderDustRecipe ENDER_DUST = new EnderDustRecipe();
        EnderiamRecipe ENDERIAM = new EnderiamRecipe();
        SawRecipe SAW = new SawRecipe();
        if (CreateDirectories.isAE2Installed()) {
            ENDER_MECHANISM.EnderMechanismRecipeSequencial(Ae2DependenciesFolder);
            COMPUTING_MECHANISM.ComputingMechanismRecipeSequencial(Ae2DependenciesFolder);
            ENDER_DUST.EnderDustRecipeMilling(Ae2DependenciesFolder);
            ENDERIAM.EnderiamRecipeMixing(Ae2DependenciesFolder);
        } else {
            this.deleteFolder(Ae2DependenciesFolder);
        }
        WOODEN_MECHANISM.WoodenMechanismRecipeShapeless(baseFolder);
        WOODEN_MECHANISM.WoodenMechanismRecipeSequencial(baseFolder);
        RUBBER_MECHANISM.RubberMechanismRecipeShaped(baseFolder);
        RUBBER_MECHANISM.RubberMechanismRecipeSequencial(baseFolder);
        ZINC_MECHANISM.ZincMechanismRecipeSequencial(baseFolder);
        ZINC_MECHANISM.ZincMechanismRecipeShaped(baseFolder);
        HEAT_MECHANISM.HeatMechanismRecipeSequencial(baseFolder);
        HEAT_MECHANISM.HeatMechanismRecipeShaped(baseFolder);
        ADVANCED_PRECISION_MECHANISM.AdvancedPrecisionMechanismRecipeSequencial(baseFolder);
        SAW.IronSawRecipe(baseFolder);
        SAW.CopperSawRecipe(baseFolder);
        SAW.DiamondSawRecipe(baseFolder);
        RUBBER.CuredRubberRecipe(baseFolder);
        RUBBER.RubberRecipe(baseFolder);
        BRONZE.BronzeRecipe(baseFolder);
    }

    public static boolean isAE2Installed() {
        String[] foldersToCheck;
        File[] files;
        String ae2Name = "appliedenergistics";
        File modsFolder = new File(".", "mods");
        if (modsFolder.exists() && modsFolder.isDirectory() && (files = modsFolder.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().toLowerCase().contains(ae2Name)) continue;
                return true;
            }
        }
        File rootDir = new File(".");
        for (String folderName : foldersToCheck = new String[]{".", "config", "kubejs", "scripts", "server_scripts", "client_scripts"}) {
            File[] files2;
            File folder = new File(rootDir, folderName);
            if (!folder.exists() || !folder.isDirectory() || (files2 = folder.listFiles()) == null) continue;
            for (File file : files2) {
                if (!file.getName().toLowerCase().contains(ae2Name)) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteFolder(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteFolder(file);
                        continue;
                    }
                    file.delete();
                }
            }
            folder.delete();
        }
    }
}

