/*
 * Decompiled with CFR 0.152.
 */
package net.TakeruDavis.create_cardboarded_conveynience.utils;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandler;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandlerClient;
import com.simibubi.create.content.logistics.box.PackageRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.TakeruDavis.create_cardboarded_conveynience.utils.SkyhookHelper;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;

public class CardboardHelper {
    private static Cache<UUID, Integer> BOXES_PLAYERS_ARE_HIDING_AS;
    private static final Map<EquipmentSlot, ResourceLocation> CARDBOARD_ARMOR;

    private static void initLinked() {
        try {
            Field f = CardboardArmorHandlerClient.class.getDeclaredField("BOXES_PLAYERS_ARE_HIDING_AS");
            f.setAccessible(true);
            BOXES_PLAYERS_ARE_HIDING_AS = (Cache)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static boolean testForArmor(LivingEntity entity) {
        for (Map.Entry<EquipmentSlot, ResourceLocation> entry : CARDBOARD_ARMOR.entrySet()) {
            ItemStack stack = entity.getItemBySlot(entry.getKey());
            Item expected = (Item)BuiltInRegistries.ITEM.get(entry.getValue());
            if (expected != null && expected.equals(stack.getItem())) continue;
            return false;
        }
        return true;
    }

    public static Integer getCurrentBoxIndex(Player player) throws ExecutionException {
        if (BOXES_PLAYERS_ARE_HIDING_AS == null) {
            CardboardHelper.initLinked();
        }
        return (Integer)BOXES_PLAYERS_ARE_HIDING_AS.get((Object)player.getUUID(), () -> player.level().random.nextInt(AllPartialModels.PACKAGES_TO_HIDE_AS.size()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerRendersAsBoxWhenSneaking(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (CardboardArmorHandler.testForStealth((Entity)player)) {
            event.setCanceled(true);
            if (player != Minecraft.getInstance().player || Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON) {
                PoseStack ms = event.getPoseStack();
                ms.pushPose();
                ms.translate(0.0f, 0.125f, 0.0f);
                float movement = (float)player.position().subtract(player.xo, player.yo, player.zo).length();
                if (player.onGround()) {
                    ms.translate(0.0f, Math.min(Math.abs(Mth.cos((float)(AnimationTickHolder.getRenderTime() % 256.0f / 2.0f))) * 2.0f / 16.0f, movement * 5.0f), 0.0f);
                }
                float interpolatedYaw = Mth.lerp((float)event.getPartialTick(), (float)player.yRotO, (float)player.getYRot());
                try {
                    PartialModel model = (PartialModel)AllPartialModels.PACKAGES_TO_HIDE_AS.get(CardboardHelper.getCurrentBoxIndex(player));
                    if (SkyhookHelper.isPlayerHanging(player)) {
                        ms.translate(0.0, player.getAbilities().flying ? 0.5 : 0.75, 0.0);
                        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                        itemRenderer.renderStatic(player.getMainHandItem(), ItemDisplayContext.FIXED, event.getPackedLight(), OverlayTexture.NO_OVERLAY, ms, event.getMultiBufferSource(), player.level(), 0);
                        ms.translate(0.0, -0.9, 0.0);
                    }
                    PackageRenderer.renderBox((Entity)player, (float)interpolatedYaw, (PoseStack)ms, (MultiBufferSource)event.getMultiBufferSource(), (int)event.getPackedLight(), (PartialModel)model);
                }
                catch (ExecutionException var6) {
                    var6.printStackTrace();
                }
                ms.popPose();
            }
        }
    }

    static {
        CARDBOARD_ARMOR = Map.of(EquipmentSlot.HEAD, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cardboard_helmet"), EquipmentSlot.CHEST, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cardboard_chestplate"), EquipmentSlot.LEGS, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cardboard_leggings"), EquipmentSlot.FEET, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cardboard_boots"));
    }
}

