/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.datagen;

import com.mrbysco.measurements.registration.MeasurementRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MeasurementsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new MeasurementsRecipeProvider(packOutput, lookupProvider));
        }
    }

    public static class MeasurementsRecipeProvider
    extends RecipeProvider {
        public MeasurementsRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput output) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)MeasurementRegistry.TAPE_MEASURE_ITEM.get())).pattern(" G ").pattern("GIY").pattern(" GY").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('G'), (ItemLike)Items.GRAY_WOOL).unlockedBy("has_iron_ingot", MeasurementsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_yellow_wool", MeasurementsRecipeProvider.has((ItemLike)Items.YELLOW_WOOL)).unlockedBy("has_gray_wool", MeasurementsRecipeProvider.has((ItemLike)Items.GRAY_WOOL)).save(output);
        }
    }
}

