/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.compat.jei.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.Pandarix.BACommon;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class IdentifyingRecipe
implements Recipe<CraftingInput> {
    private final Ingredient input;
    private final ItemStack result;
    private static int POSSIBLE_RESULT_COUNT = 0;

    public IdentifyingRecipe(Ingredient inputItems, ItemStack result) {
        this.input = inputItems;
        this.result = result;
    }

    public boolean matches(CraftingInput pInput, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return this.input.test(pInput.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        return this.getResultItem(pRegistries);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        if (POSSIBLE_RESULT_COUNT == 0) {
            try {
                POSSIBLE_RESULT_COUNT = pRegistries.lookupOrThrow(Registries.ENCHANTMENT).listElementIds().filter(reference -> reference.registryKey().registry().getNamespace().equals("betterarcheology")).toList().size();
            }
            catch (Exception e) {
                BACommon.LOGGER.error("Could not load possible enchantments!", (Throwable)e);
            }
        }
        return this.getResult(POSSIBLE_RESULT_COUNT);
    }

    public ItemStack getResult(int amountOfEnchantsPossible) {
        ItemStack modifiedResultBook = this.result.copy();
        modifiedResultBook.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.betterarcheology.identified_artifact"));
        modifiedResultBook.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)String.format("Chance: 1/%d", amountOfEnchantsPossible)).withColor(ChatFormatting.AQUA.getColor().intValue()))));
        return modifiedResultBook;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<IdentifyingRecipe> {
        private static final MapCodec<IdentifyingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.input), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, IdentifyingRecipe::new));
        public static final Serializer INSTANCE = new Serializer();
        public static final StreamCodec<RegistryFriendlyByteBuf, IdentifyingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<IdentifyingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, IdentifyingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static IdentifyingRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf friendlyByteBuf) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            ItemStack result = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)friendlyByteBuf);
            return new IdentifyingRecipe(input, result);
        }

        public static void toNetwork(@NotNull RegistryFriendlyByteBuf pBuffer, IdentifyingRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
        }
    }

    public static class Type
    implements RecipeType<IdentifyingRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

