/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_neoforge.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "configurableextramobdrops";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "mobdropconfig.txt");
    public static HashMap<EntityType<?>, CopyOnWriteArrayList<ItemStack>> mobdrops = new HashMap();
    private static final List<EntityType<?>> specialmiscmobs = new ArrayList<EntityType>(Arrays.asList(EntityType.IRON_GOLEM, EntityType.SNOW_GOLEM, EntityType.VILLAGER));
    private static boolean loadedMobConfigFile = false;

    public static void attemptLoadMobConfigFile(Level level) {
        if (loadedMobConfigFile) {
            return;
        }
        try {
            Util.loadMobConfigFile(level);
        }
        catch (Exception ex) {
            System.out.println("[Configurable Extra Mob Drops] Error on loading the entity config file. The mod has been disabled.");
        }
        loadedMobConfigFile = true;
    }

    public static void loadMobConfigFile(Level level) throws IOException {
        mobdrops = new HashMap();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            boolean ignored = dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", StandardCharsets.UTF_8);
        } else {
            String configcontent = Files.readString(Paths.get(dirpath + File.separator + "mobdropconfig.txt", new String[0]));
            for (String line : configcontent.split("\n")) {
                String[] linespl;
                if (line.trim().endsWith(",")) {
                    line = line.trim();
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() < 5 || !line.contains("' : '") || (linespl = line.split("' : '")).length < 2) continue;
                String entityrl = linespl[0].substring(1).trim();
                String itemstring = linespl[1].trim();
                itemstring = itemstring.substring(0, itemstring.length() - 1).trim();
                EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityrl));
                CopyOnWriteArrayList<ItemStack> thedrops = new CopyOnWriteArrayList<ItemStack>();
                if (itemstring.length() > 3) {
                    for (String itemdata : itemstring.split(StringFunctions.escapeSpecialRegexChars((String)"|||"))) {
                        ItemStack itemstack = null;
                        try {
                            CompoundTag newnbt = TagParser.parseTag((String)itemdata);
                            Optional optionalItemStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)newnbt);
                            if (optionalItemStack.isPresent()) {
                                itemstack = (ItemStack)optionalItemStack.get();
                            }
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                        if (itemstack == null) continue;
                        thedrops.add(itemstack.copy());
                    }
                }
                mobdrops.put(entitytype, thedrops);
            }
        }
        if (writer != null) {
            for (ResourceLocation rl : BuiltInRegistries.ENTITY_TYPE.keySet()) {
                EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(rl);
                MobCategory classification = entitytype.getCategory();
                if (classification.equals((Object)MobCategory.MISC) && !specialmiscmobs.contains(entitytype)) continue;
                writer.println("'" + String.valueOf(rl) + "' : '',");
                mobdrops.put(entitytype, new CopyOnWriteArrayList());
            }
            writer.close();
        }
    }

    public static boolean writeDropsMapToFile(Level level) throws IOException {
        if (!dir.isDirectory() || !file.isFile()) {
            boolean bl = dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", StandardCharsets.UTF_8);
        for (ResourceLocation rl : BuiltInRegistries.ENTITY_TYPE.keySet()) {
            CopyOnWriteArrayList<ItemStack> drops;
            EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(rl);
            MobCategory classification = entitytype.getCategory();
            if (classification.equals((Object)MobCategory.MISC) && !specialmiscmobs.contains(entitytype)) continue;
            StringBuilder itemdata = new StringBuilder();
            if (mobdrops.containsKey(entitytype) && !(drops = mobdrops.get(entitytype)).isEmpty()) {
                for (ItemStack drop : drops) {
                    if (!itemdata.toString().isEmpty()) {
                        itemdata.append("|||");
                    }
                    String nbtstring = ItemFunctions.getNBTStringFromItemStack((Level)level, (ItemStack)drop);
                    itemdata.append(nbtstring);
                }
            }
            writer.println("'" + String.valueOf(rl) + "' : '" + String.valueOf(itemdata) + "',");
        }
        writer.close();
        return true;
    }
}

