/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_neoforge.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.configurableextramobdrops_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class CommandCemd {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cemd").requires(iCommandSender -> iCommandSender.hasPermission(2))).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        })).then(Commands.literal((String)"usage").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        }))).then(Commands.literal((String)"list").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ArrayList<String> mobnames = new ArrayList<String>();
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String lowerregister = BuiltInRegistries.ENTITY_TYPE.getKey(et).toString().toLowerCase();
                String[] nspl = lowerregister.split(":");
                if (nspl.length < 2) continue;
                String after = nspl[1];
                if (!nspl[0].equalsIgnoreCase("minecraft")) {
                    after = lowerregister.replace(":", "-");
                }
                mobnames.add(after);
            }
            Collections.sort(mobnames);
            StringBuilder output = new StringBuilder();
            for (String mobname : mobnames) {
                if (!output.toString().isEmpty()) {
                    output.append(", ");
                }
                output.append(mobname);
            }
            output.append(".");
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Available entity names:", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)output.toString(), (ChatFormatting)ChatFormatting.YELLOW);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"To add a drop: /cemd addhand <entity-name>", (ChatFormatting)ChatFormatting.DARK_GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Note: for modded entities use - not :", (ChatFormatting)ChatFormatting.RED);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }))).then(Commands.literal((String)"reload").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                Util.loadMobConfigFile((Level)source.getLevel());
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while reloading the mob drop config file.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Successfully loaded the mob drop config file.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.literal((String)"addhand").then(Commands.argument((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandCemd.processAddhand((CommandContext<CommandSourceStack>)command, 1.0))))).then(Commands.literal((String)"addhand").then(Commands.argument((String)"entity-name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"drop-chance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            double chance = DoubleArgumentType.getDouble((CommandContext)command, (String)"drop-chance");
            if (chance < 0.0 || chance > 1.0) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"The chance has to be in between 0 and 1.0.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            return CommandCemd.processAddhand((CommandContext<CommandSourceStack>)command, chance);
        }))))).then(Commands.literal((String)"cleardrops").then(Commands.argument((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            String entityname = StringArgumentType.getString((CommandContext)command, (String)"entity-name").toLowerCase().trim();
            EntityType<?> entitytype = null;
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String registrystring = BuiltInRegistries.ENTITY_TYPE.getKey(et).toString();
                if (!registrystring.contains(":")) continue;
                if (entityname.contains("-")) {
                    if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                    entitytype = et;
                    break;
                }
                if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
                entitytype = et;
                break;
            }
            if (entitytype == null) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (ChatFormatting)ChatFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            if (!Util.mobdrops.containsKey(entitytype)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (ChatFormatting)ChatFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            Util.mobdrops.put(entitytype, new CopyOnWriteArrayList());
            try {
                if (!Util.writeDropsMapToFile((Level)source.getLevel())) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"!Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
                }
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
            }
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully cleared all drops for the entity '" + entitytype.getDescription().getString() + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))));
    }

    private static int processAddhand(CommandContext<CommandSourceStack> command, double dropChance) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        String entityname = StringArgumentType.getString(command, (String)"entity-name").toLowerCase().trim();
        EntityType<?> entitytype = null;
        for (EntityType<?> et : Util.mobdrops.keySet()) {
            String registrystring = BuiltInRegistries.ENTITY_TYPE.getKey(et).toString();
            if (!registrystring.contains(":")) continue;
            if (entityname.contains("-")) {
                if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                entitytype = et;
                break;
            }
            if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
            entitytype = et;
            break;
        }
        if (entitytype == null) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (ChatFormatting)ChatFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        if (!Util.mobdrops.containsKey(entitytype)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (ChatFormatting)ChatFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        ItemStack hand = player.getMainHandItem();
        if (hand.isEmpty()) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Your hand is empty! Unable to add drop.", (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        Level level = player.level();
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putDouble("dropChance", dropChance);
        ItemStack toAddStack = hand.copy();
        toAddStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
        Util.mobdrops.get(entitytype).add(toAddStack);
        try {
            if (!Util.writeDropsMapToFile(level)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"!Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
            }
        }
        catch (Exception ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully added '" + toAddStack.getCount() + " " + toAddStack.getHoverName().getString().toLowerCase() + "' as a drop for the entity '" + entitytype.getDescription().getString() + "' with a drop chance of '" + dropChance + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }

    private static void showUsage(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Configurable Extra Mob Drops Usage:", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd usage", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Show this message.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd list", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Lists available entities to add drops to.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd reload", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Reloads the config file.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd addhand <entity-name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Add your hand to the entity's drops with a 100% chance.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd addhand <entity-name> <drop-chance>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Add your hand to the entity's drops with drop-chance in between 0 and 1.0.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd cleardrops <entity-name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Clears all drops of the specified entity.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }

    private static void showList(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd list", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Lists available entities to add drops to.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }
}

