/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_forge.events;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.configurableextramobdrops_common_forge.util.Util;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class MobDropEvent {
    public static void onWorldLoad(Level level) {
        Util.attemptLoadMobConfigFile(level);
    }

    public static void mobItemDrop(Level level, Entity entity, DamageSource damageSource) {
        if (level.isClientSide) {
            return;
        }
        EntityType entityType = entity.getType();
        if (!Util.mobdrops.containsKey(entityType)) {
            return;
        }
        CopyOnWriteArrayList<ItemStack> extradrops = Util.mobdrops.get(entityType);
        if (!extradrops.isEmpty()) {
            BlockPos ePos = entity.blockPosition();
            for (ItemStack extraDropStack : extradrops) {
                ItemStack newStack = extraDropStack.copy();
                if (newStack.has(DataComponents.CUSTOM_DATA)) {
                    CustomData customData = (CustomData)newStack.get(DataComponents.CUSTOM_DATA);
                    if (customData == null) continue;
                    CompoundTag compoundTag = customData.copyTag();
                    if (compoundTag.contains("dropChance")) {
                        double chanceroll;
                        double dropChance = compoundTag.getDouble("dropChance");
                        if (dropChance != 1.0 && (chanceroll = GlobalVariables.random.nextDouble()) > dropChance) continue;
                        if (compoundTag.size() == 1) {
                            newStack.remove(DataComponents.CUSTOM_DATA);
                        } else {
                            compoundTag.remove("dropChance");
                            newStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
                        }
                    }
                }
                level.addFreshEntity((Entity)new ItemEntity(level, (double)ePos.getX(), (double)(ePos.getY() + 1), (double)ePos.getZ(), newStack));
            }
        }
    }
}

