/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createatam.item;

import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mcreator.createatam.procedures.StickyBootsBootsTickEventProcedure;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class StickyBootsItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 3);
                map.put(ArmorItem.Type.LEGGINGS, 6);
                map.put(ArmorItem.Type.CHESTPLATE, 7);
                map.put(ArmorItem.Type.HELMET, 3);
                map.put(ArmorItem.Type.BODY, 7);
            }), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"block.slime_block.fall")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SLIME_BALL)}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"create_things_and_misc:sticky"))), 1.0f, 0.0f);
            registerHelper.register(ResourceLocation.parse((String)"create_things_and_misc:sticky_boots"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    public StickyBootsItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends StickyBootsItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(20)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.create_things_and_misc.sticky_boots_boots.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                StickyBootsBootsTickEventProcedure.execute(entity);
            }
        }
    }
}

