/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public record FluidExistsCondition(String fluid) implements ICondition
{
    public static MapCodec<FluidExistsCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("fluid_exists").forGetter(FluidExistsCondition::fluid)).apply((Applicative)builder, FluidExistsCondition::new));

    @Override
    public String toString() {
        return "fluid_exists(\"" + this.fluid + "\")";
    }

    public boolean test(ICondition.IContext context) {
        ResourceLocation fluidLocation = ResourceLocation.tryParse((String)this.fluid);
        if (fluidLocation == null) {
            return false;
        }
        if (fluidLocation.getNamespace().startsWith("#")) {
            return true;
        }
        return BuiltInRegistries.FLUID.containsKey(fluidLocation);
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

