/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractCraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.jei.common.CraftingGridRecipeTransferError;
import com.refinedmods.refinedstorage.jei.common.SlotUtil;
import com.refinedmods.refinedstorage.jei.common.TransferInput;
import com.refinedmods.refinedstorage.jei.common.TransferInputType;
import com.refinedmods.refinedstorage.jei.common.TransferType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

class CraftingGridRecipeTransferHandler<T extends AbstractCraftingGridContainerMenu>
implements IRecipeTransferHandler<T, RecipeHolder<CraftingRecipe>> {
    private final Class<T> clazz;

    CraftingGridRecipeTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T containerMenu, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ResourceRepository repository = containerMenu.getRepository();
        MutableResourceList available = containerMenu.getAvailableListForRecipeTransfer();
        List<TransferInput> transferInputs = this.getTransferInputs((ResourceRepository<GridResource>)repository, recipeSlots, available);
        TransferType type = this.getTransferType(transferInputs);
        if (doTransfer) {
            if (type.canOpenAutocraftingPreview() && Screen.hasControlDown()) {
                this.openAutocraftingPreview(transferInputs);
                return RecipeTransferErrorInternal.INSTANCE;
            }
            this.doTransfer(recipeSlots, (AbstractCraftingGridContainerMenu)containerMenu);
            return null;
        }
        return type == TransferType.AVAILABLE ? null : new CraftingGridRecipeTransferError(transferInputs, type);
    }

    private void openAutocraftingPreview(List<TransferInput> transferInputs) {
        Screen screen;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof IRecipesGui) {
            IRecipesGui recipesGui = (IRecipesGui)screen2;
            screen = recipesGui.getParentScreen().orElse(null);
        } else {
            screen = null;
        }
        Screen parentScreen = screen;
        List<ResourceAmount> craftingRequests = CraftingGridRecipeTransferHandler.createCraftingRequests(transferInputs);
        RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(craftingRequests, parentScreen);
    }

    private TransferType getTransferType(List<TransferInput> transferInputs) {
        if (transferInputs.stream().allMatch(input -> input.type() == TransferInputType.AVAILABLE)) {
            return TransferType.AVAILABLE;
        }
        boolean hasMissing = transferInputs.stream().anyMatch(input -> input.type() == TransferInputType.MISSING);
        boolean hasAutocraftable = transferInputs.stream().anyMatch(input -> input.type() == TransferInputType.AUTOCRAFTABLE);
        if (hasMissing && hasAutocraftable) {
            return TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE;
        }
        if (hasAutocraftable) {
            return TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE;
        }
        return TransferType.MISSING;
    }

    private void doTransfer(IRecipeSlotsView recipeSlots, AbstractCraftingGridContainerMenu containerMenu) {
        List<List<ItemResource>> inputs = SlotUtil.getItems(recipeSlots, RecipeIngredientRole.INPUT);
        containerMenu.transferRecipe(inputs);
    }

    private List<TransferInput> getTransferInputs(ResourceRepository<GridResource> repository, IRecipeSlotsView recipeSlots, MutableResourceList available) {
        return recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(slotView -> !slotView.isEmpty()).map(slotView -> this.toTransferInput(repository, available, (IRecipeSlotView)slotView)).toList();
    }

    private TransferInput toTransferInput(ResourceRepository<GridResource> repository, MutableResourceList available, IRecipeSlotView slotView) {
        List possibilities = slotView.getItemStacks().toList();
        for (ItemStack possibility : possibilities) {
            ItemResource possibilityResource = ItemResource.ofItemStack((ItemStack)possibility);
            if (available.remove((ResourceKey)possibilityResource, 1L) == null) continue;
            return new TransferInput(slotView, TransferInputType.AVAILABLE, null);
        }
        List<ItemResource> autocraftingPossibilities = possibilities.stream().map(ItemResource::ofItemStack).filter(arg_0 -> repository.isSticky(arg_0)).sorted(Comparator.comparingLong(arg_0 -> repository.getAmount(arg_0))).toList();
        if (!autocraftingPossibilities.isEmpty()) {
            return new TransferInput(slotView, TransferInputType.AUTOCRAFTABLE, autocraftingPossibilities.getFirst());
        }
        return new TransferInput(slotView, TransferInputType.MISSING, null);
    }

    private static List<ResourceAmount> createCraftingRequests(List<TransferInput> transferInputs) {
        MutableResourceListImpl requests = MutableResourceListImpl.orderPreserving();
        for (TransferInput transferInput : transferInputs) {
            if (transferInput.type() != TransferInputType.AUTOCRAFTABLE || transferInput.autocraftableResource() == null) continue;
            requests.add((ResourceKey)transferInput.autocraftableResource(), 1L);
        }
        return requests.copyState().stream().toList();
    }
}

