/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask;

import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.muon.questkilltask.DamageTracker;
import dev.muon.questkilltask.QuestKillTask;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class QuestProcessor {
    private static List<KillTask> killTasks;

    public static void markDirty() {
        killTasks = null;
    }

    private void initKillTasks() {
        if (killTasks == null && ServerQuestFile.INSTANCE != null) {
            killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
        }
    }

    public boolean shouldProcessKill(LivingEntity entity) {
        boolean hasContributors;
        if (entity.level().isClientSide()) {
            return false;
        }
        if (killTasks == null && ServerQuestFile.INSTANCE != null) {
            killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
        }
        if (killTasks == null || killTasks.isEmpty()) {
            return false;
        }
        DamageTracker.KillContributors contributors = DamageTracker.getKillContributors(entity);
        boolean bl = hasContributors = !contributors.damagers().isEmpty() || !contributors.healers().isEmpty() || !contributors.tanks().isEmpty();
        return hasContributors;
    }

    public ServerQuestFile getQuestFile() {
        ServerQuestFile questFile = ServerQuestFile.INSTANCE;
        if (questFile == null) {
            QuestKillTask.LOG.warn("Could not get Server Quest File instance!");
            return null;
        }
        this.initKillTasks();
        if (killTasks == null || killTasks.isEmpty()) {
            QuestKillTask.LOG.warn("No kill tasks were present in the current quest file!");
            return null;
        }
        return questFile;
    }

    public void processDamagingTeams(LivingEntity entity, ServerQuestFile questFile) {
        HashSet<UUID> processedTeams = new HashSet<UUID>();
        DamageTracker.KillContributors contributors = DamageTracker.getKillContributors(entity);
        HashSet<UUID> allContributors = new HashSet<UUID>();
        allContributors.addAll(contributors.damagers());
        allContributors.addAll(contributors.healers());
        allContributors.addAll(contributors.tanks());
        for (UUID playerUUID : allContributors) {
            this.processPlayerContribution(playerUUID, entity, questFile, processedTeams);
        }
    }

    private void processPlayerContribution(UUID playerUUID, LivingEntity entity, ServerQuestFile questFile, Set<UUID> processedTeams) {
        ServerPlayer player = questFile.server.getPlayerList().getPlayer(playerUUID);
        if (player == null) {
            return;
        }
        TeamData playerTeam = questFile.getOrCreateTeamData((Entity)player);
        if (!this.isValidTeam(playerTeam)) {
            return;
        }
        if (!processedTeams.add(playerTeam.getTeamId())) {
            return;
        }
        this.updateTeamKillTasks(playerTeam, entity);
    }

    private boolean isValidTeam(TeamData playerTeam) {
        return playerTeam != null && !playerTeam.isLocked();
    }

    private void updateTeamKillTasks(TeamData team, LivingEntity entity) {
        for (KillTask task : killTasks) {
            if (!this.canCompleteTask(team, task)) continue;
            task.kill(team, entity);
        }
    }

    private boolean canCompleteTask(TeamData team, KillTask task) {
        return team.getProgress((Task)task) < task.getMaxProgress() && team.canStartTasks(task.getQuest());
    }
}

