/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ElementListWidgetExt<E extends Entry<E>>
extends ContainerObjectSelectionList<E>
implements LayoutElement {
    protected static final int SCROLLBAR_WIDTH = 6;
    private double smoothScrollAmount = this.scrollAmount();
    private boolean returnSmoothAmount = false;
    private final boolean doSmoothScrolling;
    private boolean usingScrollbar;

    public ElementListWidgetExt(Minecraft client, int x, int y, int width, int height, boolean smoothScrolling) {
        super(client, width, x, y, height);
        this.doSmoothScrolling = smoothScrolling;
        this.setRenderHeader(false, 0);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        double scroll = vertical + horizontal;
        this.setScrollAmount(this.scrollAmount() - scroll * 20.0);
        return true;
    }

    protected int scrollBarX() {
        return this.getScrollbarPosition();
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - 6;
    }

    protected int maxScrollAmount() {
        return this.getMaxPosition();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.usingScrollbar) {
            this.resetSmoothScrolling();
        }
        this.smoothScrollAmount = Mth.lerp((double)((double)delta * 0.5), (double)this.smoothScrollAmount, (double)this.scrollAmount());
        if (Math.abs(this.smoothScrollAmount - this.scrollAmount()) < 1.0E-5) {
            this.smoothScrollAmount = this.scrollAmount();
        }
        this.returnSmoothAmount = true;
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        super.renderWidget(graphics, mouseX, mouseY, delta);
        graphics.disableScissor();
        this.returnSmoothAmount = false;
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.scrollBarX() && mouseX < (double)(this.scrollBarX() + 6)) {
            this.usingScrollbar = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.usingScrollbar = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void updateDimensions(ScreenRectangle rectangle) {
        this.setX(rectangle.left());
        this.setY(rectangle.top());
        this.setWidth(rectangle.width());
        this.setHeight(rectangle.height());
    }

    protected double scrollAmount() {
        return this.getScrollAmount();
    }

    public double getScrollAmount() {
        if (this.returnSmoothAmount && this.doSmoothScrolling) {
            return this.smoothScrollAmount;
        }
        return super.getScrollAmount();
    }

    protected void resetSmoothScrolling() {
        this.smoothScrollAmount = super.getScrollAmount();
    }

    @Nullable
    protected E getEntryAtPosition(double x, double y) {
        y += this.scrollAmount();
        if (x < (double)this.getX() || x > (double)(this.getX() + this.getWidth())) {
            return null;
        }
        int currentY = this.getY() - this.headerHeight + 4;
        for (Entry entry : this.children()) {
            if (y >= (double)currentY && y <= (double)(currentY + entry.getItemHeight())) {
                return (E)((Object)entry);
            }
            currentY += entry.getItemHeight();
        }
        return null;
    }

    protected int contentHeight() {
        return this.getMaxPosition();
    }

    protected int getMaxPosition() {
        return this.children().stream().mapToInt(Entry::getItemHeight).sum() + this.headerHeight;
    }

    protected void centerScrollOn(E entry) {
        double d = (double)this.height / -2.0;
        for (int i = 0; i < this.children().indexOf(entry) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)((Object)this.children().get(i))).getItemHeight();
        }
        this.setScrollAmount(d);
    }

    protected int getRowTop(int index) {
        int integer = this.getY() + 4 - (int)this.scrollAmount() + this.headerHeight;
        for (int i = 0; i < this.children().size() && i < index; ++i) {
            integer += ((Entry)((Object)this.children().get(i))).getItemHeight();
        }
        return integer;
    }

    protected void ensureVisible(E entry) {
        int k;
        int entryIndex = this.children().indexOf(entry);
        int top = this.getRowTop(entryIndex);
        int j = top - this.getY() - 4 - ((Entry)((Object)entry)).getItemHeight();
        if (j < 0) {
            this.setScrollAmount(this.scrollAmount() + (double)j);
        }
        if ((k = this.getY() + this.getHeight() - top - ((Entry)((Object)entry)).getItemHeight() * 2) < 0) {
            this.setScrollAmount(this.scrollAmount() - (double)k);
        }
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int left = this.getRowLeft();
        int right = this.getRowWidth();
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            Entry entry = (Entry)((Object)this.children().get(i));
            int top = this.getRowTop(i);
            int bottom = top + entry.getItemHeight();
            int entryHeight = entry.getItemHeight() - 4;
            if (bottom < this.getY() || top > this.getY() + this.getHeight()) continue;
            this.renderItem(graphics, mouseX, mouseY, delta, i, left, top, right, entryHeight);
        }
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (GuiEventListener child : this.children()) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                if (button == 0 || button == 1) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDragging() && (button == 0 || button == 1)) {
                for (GuiEventListener child : this.children()) {
                    if (!child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
                    return true;
                }
            }
            return false;
        }

        public int getItemHeight() {
            return 22;
        }
    }
}

