/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import io.redspace.ironsspellbooks.api.util.Utils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarBedBlockEntity;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarStorageBlockEntity;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.network.FamiliarDataPacket;
import net.alshanex.familiarslib.network.SyncBedLinkDataPacket;
import net.alshanex.familiarslib.network.SyncFamiliarDataPacket;
import net.alshanex.familiarslib.network.UpdateFamiliarStoragePacket;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.screen.BedLinkSelectionScreen;
import net.alshanex.familiarslib.screen.FamiliarStorageScreen;
import net.alshanex.familiarslib.screen.FamiliarWanderScreen;
import net.alshanex.familiarslib.util.familiars.FamiliarAttributesHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class FamiliarManager {
    private static final Set<UUID> deadFamiliars = new HashSet<UUID>();

    public static void markFamiliarAsDead(UUID familiarId) {
        deadFamiliars.add(familiarId);
        FamiliarsLib.LOGGER.debug("Marked familiar {} as dead", (Object)familiarId);
    }

    public static boolean isFamiliarDead(UUID familiarId) {
        return deadFamiliars.contains(familiarId);
    }

    public static void unmarkFamiliarAsDead(UUID familiarId) {
        deadFamiliars.remove(familiarId);
        FamiliarsLib.LOGGER.debug("Unmarked familiar {} as dead", (Object)familiarId);
    }

    public static boolean handleFamiliarTaming(AbstractSpellCastingPet familiar, ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (!familiarData.canTameMoreFamiliars()) {
            FamiliarsLib.LOGGER.debug("Player {} tried to tame familiar but is at max capacity ({}/{})", new Object[]{player.getName().getString(), familiarData.getFamiliarCount(), 10});
            return false;
        }
        CompoundTag familiarNBT = FamiliarManager.createFamiliarNBT(familiar);
        UUID familiarId = familiar.getUUID();
        boolean success = familiarData.tryAddTamedFamiliar(familiarId, familiarNBT);
        if (success) {
            if (familiarData.getSelectedFamiliarId() == null) {
                familiarData.setSelectedFamiliarId(familiarId);
            }
            FamiliarManager.syncFamiliarData(player, familiarData);
            FamiliarsLib.LOGGER.debug("Player {} successfully tamed familiar {}. ({}/{})", new Object[]{player.getName().getString(), familiarId, familiarData.getFamiliarCount(), 10});
            return true;
        }
        FamiliarsLib.LOGGER.error("Failed to add familiar to player data despite limit check");
        return false;
    }

    public static boolean canPlayerTameMoreFamiliars(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.canTameMoreFamiliars();
    }

    public static String getFamiliarCapacityInfo(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getFamiliarCount() + "/10";
    }

    public static void handleFamiliarSummoning(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        UUID selectedFamiliarId = familiarData.getSelectedFamiliarId();
        FamiliarsLib.LOGGER.debug("Handling familiar summoning for player: {}", (Object)player.getName().getString());
        FamiliarsLib.LOGGER.debug("Selected familiar ID: {}", (Object)selectedFamiliarId);
        if (selectedFamiliarId == null) {
            FamiliarsLib.LOGGER.debug("No familiar selected, aborting summoning");
            return;
        }
        ServerLevel level = player.serverLevel();
        Entity existingEntity = level.getEntity(selectedFamiliarId);
        boolean familiarExistsInWorld = existingEntity instanceof AbstractSpellCastingPet;
        FamiliarsLib.LOGGER.debug("Familiar exists in world: {}", (Object)familiarExistsInWorld);
        if (familiarExistsInWorld) {
            FamiliarsLib.LOGGER.debug("Dessummoning familiar: {}", (Object)selectedFamiliarId);
            FamiliarManager.desummonFamiliar(player, selectedFamiliarId);
        } else {
            FamiliarsLib.LOGGER.debug("Summoning familiar: {}", (Object)selectedFamiliarId);
            FamiliarManager.summonFamiliar(player, selectedFamiliarId);
        }
    }

    public static void summonFamiliar(ServerPlayer player, UUID familiarId) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        CompoundTag familiarNBT = familiarData.getFamiliarData(familiarId);
        FamiliarsLib.LOGGER.debug("Attempting to summon familiar: {}", (Object)familiarId);
        if (familiarNBT == null) {
            FamiliarsLib.LOGGER.debug("No NBT data found for familiar: {}", (Object)familiarId);
            return;
        }
        ServerLevel level = player.serverLevel();
        String entityTypeString = familiarNBT.getString("id");
        EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
        if (entityType == null) {
            FamiliarsLib.LOGGER.debug("Unknown entity type: {}", (Object)entityTypeString);
            return;
        }
        Entity entity = entityType.create((Level)level);
        if (!(entity instanceof AbstractSpellCastingPet)) {
            FamiliarsLib.LOGGER.debug("Entity is not a familiar: {}", (Object)entity);
            return;
        }
        AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
        familiar.load(familiarNBT);
        familiar.setUUID(familiarId);
        float savedHealth = familiarNBT.getFloat("currentHealth");
        float actualMaxHealth = familiar.getMaxHealth();
        familiar.setHealth(Math.min(savedHealth, actualMaxHealth));
        Vec3 spawnPos = FamiliarManager.findSafeSpawnPosition(player, level);
        familiar.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        familiar.setYRot(player.getYRot());
        familiar.setOldPosAndRot();
        level.addFreshEntity((Entity)familiar);
        FamiliarAttributesHelper.handleFamiliarSummoned(player, familiar);
        level.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 1.0f, 1.0f);
        FamiliarsLib.LOGGER.debug("Familiar summoned: {} with health {}/{}", new Object[]{familiarId, Float.valueOf(familiar.getHealth()), Float.valueOf(familiar.getMaxHealth())});
        familiarData.setCurrentSummonedFamiliarId(familiarId);
        familiarData.addSummonedFamiliar(familiarId);
        FamiliarManager.syncFamiliarData(player, familiarData);
    }

    public static void desummonFamiliar(ServerPlayer player, UUID familiarId) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        ServerLevel level = player.serverLevel();
        FamiliarsLib.LOGGER.debug("Attempting to desummon familiar: {}", (Object)familiarId);
        Entity entity = level.getEntity(familiarId);
        if (entity instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            if (familiar.getSummoner() != null && familiar.getSummoner().is((Entity)player) && familiar.getUUID().equals(familiarId)) {
                if (familiar.isCasting()) {
                    familiar.cancelCast();
                    familiar.getMagicData().resetCastingState();
                }
                familiar.setTarget(null);
                familiar.setHasUsedSingleAttack(false);
                CompoundTag updatedNBT = FamiliarManager.createFamiliarNBT(familiar);
                familiarData.addTamedFamiliar(familiarId, updatedNBT);
                familiar.remove(Entity.RemovalReason.DISCARDED);
                FamiliarAttributesHelper.handleFamiliarDismissed(player, familiar);
                level.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                FamiliarsLib.LOGGER.debug("Familiar desummoned successfully: {}", (Object)familiarId);
                if (familiarId.equals(familiarData.getCurrentSummonedFamiliarId())) {
                    familiarData.setCurrentSummonedFamiliarId(null);
                }
                familiarData.removeSummonedFamiliar(familiarId);
            } else {
                FamiliarsLib.LOGGER.debug("Familiar found but doesn't belong to player: {}", (Object)familiarId);
            }
        } else {
            FamiliarsLib.LOGGER.debug("Familiar not found in world: {}", (Object)familiarId);
            if (familiarId.equals(familiarData.getCurrentSummonedFamiliarId())) {
                familiarData.setCurrentSummonedFamiliarId(null);
            }
            familiarData.removeSummonedFamiliar(familiarId);
        }
        FamiliarManager.syncFamiliarData(player, familiarData);
    }

    public static void updateFamiliarData(AbstractSpellCastingPet familiar) {
        LivingEntity livingEntity = familiar.getSummoner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            UUID familiarId = familiar.getUUID();
            if (FamiliarManager.isFamiliarDead(familiarId)) {
                FamiliarsLib.LOGGER.debug("Skipping update for marked dead familiar {}", (Object)familiarId);
                return;
            }
            if (familiar.getHealth() <= 0.0f) {
                FamiliarsLib.LOGGER.debug("Skipping update for dead/dying familiar {}", (Object)familiarId);
                return;
            }
            if (!familiarData.hasFamiliar(familiarId)) {
                FamiliarsLib.LOGGER.debug("Skipping update for familiar {} - not in player data (probably dead)", (Object)familiarId);
                return;
            }
            try {
                CompoundTag updatedNBT = FamiliarManager.createFamiliarNBT(familiar);
                familiarData.addTamedFamiliar(familiarId, updatedNBT);
            }
            catch (Exception e) {
                FamiliarsLib.LOGGER.error("Error updating familiar data for {}: ", (Object)familiarId, (Object)e);
            }
        }
    }

    public static CompoundTag createFamiliarNBT(AbstractSpellCastingPet familiar) {
        CompoundTag nbt = new CompoundTag();
        familiar.saveWithoutId(nbt);
        float currentHealth = familiar.getHealth();
        float maxHealth = familiar.getMaxHealth();
        nbt.putFloat("currentHealth", currentHealth);
        nbt.putFloat("maxHealthDebug", maxHealth);
        String entityTypeId = EntityType.getKey((EntityType)familiar.getType()).toString();
        nbt.putString("id", entityTypeId);
        nbt.putInt("armorStacks", familiar.getArmorStacks().intValue());
        nbt.putInt("enragedStacks", familiar.getEnragedStacks().intValue());
        nbt.putBoolean("canBlock", familiar.getIsBlocking().booleanValue());
        if (familiar.hasCustomName()) {
            nbt.putString("customName", familiar.getCustomName().getString());
        }
        FamiliarsLib.LOGGER.debug("Saving familiar {}: health stacks={}, current health={}/{}, armor stacks={}", new Object[]{familiar.getUUID(), familiar.getHealthStacks(), Float.valueOf(currentHealth), Float.valueOf(maxHealth), familiar.getArmorStacks()});
        return nbt;
    }

    private static Vec3 findSafeSpawnPosition(ServerPlayer player, ServerLevel level) {
        float yrot = 6.281f + player.getYRot() * ((float)Math.PI / 180);
        Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)player.getEyePosition().add(new Vec3((double)(3.0f * Mth.cos((float)yrot)), 0.0, (double)(3.0f * Mth.sin((float)yrot)))), (int)10);
        return spawn;
    }

    public static void syncFamiliarData(ServerPlayer player, PlayerFamiliarData familiarData) {
        try {
            Map<UUID, CompoundTag> familiarsData = familiarData.getAllFamiliars();
            UUID selectedId = familiarData.getSelectedFamiliarId();
            UUID summonedId = familiarData.getCurrentSummonedFamiliarId();
            Set<UUID> summonedIds = familiarData.getSummonedFamiliarIds();
            FamiliarsLib.LOGGER.debug("Syncing familiar data - Familiars: {}, Selected: {}, Summoned: {}, All Summoned: {}", new Object[]{familiarsData.size(), selectedId, summonedId, summonedIds.size()});
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new FamiliarDataPacket(familiarsData, selectedId, summonedId, summonedIds), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CompoundTag syncData = familiarData.serializeNBT((HolderLookup.Provider)player.registryAccess());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncFamiliarDataPacket(syncData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            BedLinkData linkData = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
            CompoundTag linkSyncData = linkData.serializeNBT((HolderLookup.Provider)player.registryAccess());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncBedLinkDataPacket(linkSyncData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            FamiliarsLib.LOGGER.debug("All data synced to client successfully");
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error syncing familiar data: ", (Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleFamiliarDataPacket(Map<UUID, CompoundTag> familiars, UUID selectedFamiliarId, UUID currentSummonedFamiliarId, Set<UUID> summonedFamiliarIds) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            PlayerFamiliarData data = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            Map<UUID, CompoundTag> currentFamiliars = data.getAllFamiliars();
            for (UUID screen : new HashSet<UUID>(currentFamiliars.keySet())) {
                data.removeTamedFamiliar(screen);
            }
            data.clearAllSummoned();
            for (Map.Entry entry : familiars.entrySet()) {
                data.addTamedFamiliar((UUID)entry.getKey(), (CompoundTag)entry.getValue());
            }
            data.setSelectedFamiliarId(selectedFamiliarId);
            data.setCurrentSummonedFamiliarId(currentSummonedFamiliarId);
            if (summonedFamiliarIds != null) {
                for (UUID uUID : summonedFamiliarIds) {
                    data.addSummonedFamiliar(uUID);
                }
            }
            FamiliarsLib.LOGGER.debug("Client received familiar data - Count: {}, Selected: {}, Summoned: {}, All Summoned: {}", new Object[]{familiars.size(), selectedFamiliarId, currentSummonedFamiliarId, summonedFamiliarIds != null ? summonedFamiliarIds.size() : 0});
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof BedLinkSelectionScreen) {
                BedLinkSelectionScreen bedLinkScreen = (BedLinkSelectionScreen)screen;
                bedLinkScreen.reloadFamiliarData();
            }
        }
    }

    public static boolean hasSelectedFamiliar(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getSelectedFamiliarId() != null;
    }

    public static boolean isFamiliarSummoned(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getCurrentSummonedFamiliarId() != null;
    }

    public static void syncFamiliarDataForPlayer(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        FamiliarManager.syncFamiliarData(player, familiarData);
    }

    public static void handleFamiliarSelection(ServerPlayer player, UUID familiarId) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (familiarData.hasFamiliar(familiarId)) {
            familiarData.setSelectedFamiliarId(familiarId);
            FamiliarManager.syncFamiliarData(player, familiarData);
        }
    }

    public static void summonSpecificFamiliarAtPosition(ServerPlayer player, UUID familiarId, int positionIndex) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        CompoundTag familiarNBT = familiarData.getFamiliarData(familiarId);
        FamiliarsLib.LOGGER.debug("Attempting to summon specific familiar: {} at position {}", (Object)familiarId, (Object)positionIndex);
        if (familiarNBT == null) {
            FamiliarsLib.LOGGER.debug("No NBT data found for familiar: {}", (Object)familiarId);
            return;
        }
        if (familiarData.isFamiliarSummoned(familiarId)) {
            FamiliarsLib.LOGGER.debug("Familiar {} is already summoned", (Object)familiarId);
            return;
        }
        String entityTypeString = familiarNBT.getString("id");
        EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
        if (entityType == null) {
            FamiliarsLib.LOGGER.debug("Unknown entity type: {}", (Object)entityTypeString);
            return;
        }
        ServerLevel level = player.serverLevel();
        Entity entity = entityType.create((Level)level);
        if (!(entity instanceof AbstractSpellCastingPet)) {
            FamiliarsLib.LOGGER.debug("Entity is not a familiar: {}", (Object)entity);
            return;
        }
        AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
        familiar.load(familiarNBT);
        familiar.setUUID(familiarId);
        float savedHealth = familiarNBT.getFloat("currentHealth");
        float actualMaxHealth = familiar.getMaxHealth();
        familiar.setHealth(Math.min(savedHealth, actualMaxHealth));
        Vec3 spawnPos = FamiliarManager.findSafeSpawnPositionWithIndex(player, level, positionIndex);
        familiar.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        familiar.setYRot(player.getYRot());
        familiar.setOldPosAndRot();
        level.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.addFreshEntity((Entity)familiar);
        FamiliarAttributesHelper.handleFamiliarSummoned(player, familiar);
        familiarData.addSummonedFamiliar(familiarId);
        FamiliarManager.syncFamiliarData(player, familiarData);
        FamiliarsLib.LOGGER.debug("Specific familiar summoned: {} at position {} with health {}/{}", new Object[]{familiarId, spawnPos, Float.valueOf(familiar.getHealth()), Float.valueOf(familiar.getMaxHealth())});
    }

    private static Vec3 findSafeSpawnPositionWithIndex(ServerPlayer player, ServerLevel level, int positionIndex) {
        double[][] spawnOffsets = new double[][]{{3.0, 0.0}, {-3.0, 0.0}, {0.0, 3.0}, {0.0, -3.0}, {2.1, 2.1}, {-2.1, 2.1}, {2.1, -2.1}, {-2.1, -2.1}, {4.0, 0.0}, {0.0, 4.0}};
        int offsetIndex = positionIndex % spawnOffsets.length;
        double[] offset = spawnOffsets[offsetIndex];
        float yrot = player.getYRot() * ((float)Math.PI / 180);
        double cos = Math.cos(yrot);
        double sin = Math.sin(yrot);
        double worldX = offset[0] * cos - offset[1] * sin;
        double worldZ = offset[0] * sin + offset[1] * cos;
        Vec3 playerPos = player.getEyePosition();
        Vec3 targetPos = playerPos.add(worldX, 0.0, worldZ);
        Vec3 spawnPos = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)targetPos, (int)10);
        for (int attempt = 0; attempt < 3; ++attempt) {
            if (FamiliarManager.isPositionSafe(level, spawnPos)) {
                return spawnPos;
            }
            double randomX = (level.random.nextDouble() - 0.5) * 2.0;
            double randomZ = (level.random.nextDouble() - 0.5) * 2.0;
            Vec3 alternativePos = targetPos.add(randomX, 0.0, randomZ);
            spawnPos = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)alternativePos, (int)10);
        }
        return FamiliarManager.findSafeSpawnPosition(player, level);
    }

    private static boolean isPositionSafe(ServerLevel level, Vec3 pos) {
        BlockPos blockPos = BlockPos.containing((Position)pos);
        boolean groundSolid = level.getBlockState(blockPos.below()).isSolid();
        boolean spaceEmpty = level.getBlockState(blockPos).isAir() && level.getBlockState(blockPos.above()).isAir();
        return groundSolid && spaceEmpty;
    }

    public static void desummonSpecificFamiliar(ServerPlayer player, UUID familiarId) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        ServerLevel level = player.serverLevel();
        FamiliarsLib.LOGGER.debug("Attempting to desummon specific familiar: {}", (Object)familiarId);
        Entity entity = level.getEntity(familiarId);
        if (entity instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            if (familiar.getSummoner() != null && familiar.getSummoner().is((Entity)player) && familiar.getUUID().equals(familiarId)) {
                if (familiar.isCasting()) {
                    familiar.cancelCast();
                    familiar.getMagicData().resetCastingState();
                }
                familiar.setTarget(null);
                familiar.setHasUsedSingleAttack(false);
                CompoundTag updatedNBT = FamiliarManager.createFamiliarNBT(familiar);
                familiarData.addTamedFamiliar(familiarId, updatedNBT);
                familiar.remove(Entity.RemovalReason.DISCARDED);
                FamiliarAttributesHelper.handleFamiliarDismissed(player, familiar);
                level.playSound(null, familiar.getX(), familiar.getY(), familiar.getZ(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                familiarData.removeSummonedFamiliar(familiarId);
                FamiliarsLib.LOGGER.debug("Specific familiar desummoned successfully: {}", (Object)familiarId);
            } else {
                FamiliarsLib.LOGGER.debug("Familiar found but doesn't belong to player: {}", (Object)familiarId);
            }
        } else {
            FamiliarsLib.LOGGER.debug("Familiar not found in world: {}", (Object)familiarId);
            familiarData.removeSummonedFamiliar(familiarId);
        }
        FamiliarManager.syncFamiliarData(player, familiarData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void syncFamiliarData(CompoundTag familiarData) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            PlayerFamiliarData data = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            data.deserializeNBT((HolderLookup.Provider)player.registryAccess(), familiarData);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openBedScreen(BlockPos bedPos) {
        Minecraft.getInstance().setScreen((Screen)new BedLinkSelectionScreen(bedPos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openStorageScreen(BlockPos blockPos) {
        BlockEntity blockEntity;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && (blockEntity = minecraft.level.getBlockEntity(blockPos)) instanceof AbstractFamiliarStorageBlockEntity) {
            AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
            if (storageEntity.isStoreMode()) {
                minecraft.setScreen((Screen)new FamiliarStorageScreen(blockPos));
            } else {
                minecraft.setScreen((Screen)new FamiliarWanderScreen(blockPos));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void syncBedData(CompoundTag bedLinkData) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            BedLinkData data = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
            data.deserializeNBT((HolderLookup.Provider)player.registryAccess(), bedLinkData);
            FamiliarsLib.LOGGER.debug("Client received bed link data sync");
        }
    }

    public static void linkFamiliarToBed(ServerPlayer serverPlayer, BlockPos bedPos, UUID familiarId) {
        FamiliarsLib.LOGGER.debug("Processing LinkFamiliarToBedPacket for player {} at pos {} with familiar {}", new Object[]{serverPlayer.getName().getString(), bedPos, familiarId});
        BlockEntity blockEntity = serverPlayer.level().getBlockEntity(bedPos);
        if (!(blockEntity instanceof AbstractFamiliarBedBlockEntity)) {
            FamiliarsLib.LOGGER.debug("Block entity is not a PetBedBlockEntity at position {}", (Object)bedPos);
            return;
        }
        AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
        if (!petBed.isOwner((Player)serverPlayer)) {
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_bed_owner").withStyle(ChatFormatting.RED)));
            FamiliarsLib.LOGGER.debug("Player {} is not the owner of bed at {}", (Object)serverPlayer.getName().getString(), (Object)bedPos);
            return;
        }
        BedLinkData linkData = (BedLinkData)serverPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
        PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (familiarId != null) {
            if (!familiarData.hasFamiliar(familiarId)) {
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_not_found").withStyle(ChatFormatting.RED)));
                FamiliarsLib.LOGGER.debug("Familiar {} not found in player data", (Object)familiarId);
                return;
            }
            FamiliarsLib.LOGGER.debug("Linking familiar {} to bed at {}", (Object)familiarId, (Object)bedPos);
            linkData.linkFamiliarToBed(familiarId, bedPos);
            String familiarName = FamiliarManager.getFamiliarName(familiarData, familiarId);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_linked_to_bed", (Object[])new Object[]{familiarName}).withStyle(ChatFormatting.GREEN)));
            FamiliarsLib.LOGGER.debug("Successfully linked familiar {} to bed", (Object)familiarId);
        } else {
            UUID previousLinked = linkData.getLinkedFamiliar(bedPos);
            if (previousLinked != null) {
                FamiliarsLib.LOGGER.debug("Unlinking familiar {} from bed at {}", (Object)previousLinked, (Object)bedPos);
                linkData.unlinkBed(bedPos);
                String familiarName = FamiliarManager.getFamiliarName(familiarData, previousLinked);
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_unlinked_from_bed", (Object[])new Object[]{familiarName}).withStyle(ChatFormatting.GREEN)));
                FamiliarsLib.LOGGER.debug("Successfully unlinked familiar {} from bed", (Object)previousLinked);
            } else {
                FamiliarsLib.LOGGER.debug("No familiar was linked to bed at {}", (Object)bedPos);
            }
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncBedLinkDataPacket(linkData.serializeNBT((HolderLookup.Provider)serverPlayer.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        FamiliarsLib.LOGGER.debug("Bed link data synced to client for player {}", (Object)serverPlayer.getName().getString());
    }

    private static String getFamiliarName(PlayerFamiliarData familiarData, UUID familiarId) {
        CompoundTag familiarNBT = familiarData.getFamiliarData(familiarId);
        if (familiarNBT != null) {
            if (familiarNBT.contains("customName")) {
                return familiarNBT.getString("customName");
            }
            String entityTypeString = familiarNBT.getString("id");
            String[] parts = entityTypeString.split(":");
            if (parts.length > 1) {
                return parts[1].replace("_", " ");
            }
            return entityTypeString.substring(entityTypeString.lastIndexOf(58) + 1);
        }
        return "Unknown";
    }

    public static void updateSummonedFamiliarsData(ServerPlayer player) {
        try {
            PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            ServerLevel level = player.serverLevel();
            HashSet<UUID> actualSummonedFamiliars = new HashSet<UUID>();
            int updatedCount = 0;
            for (Map.Entry<UUID, CompoundTag> entry : familiarData.getAllFamiliars().entrySet()) {
                AbstractSpellCastingPet familiar;
                UUID familiarId = entry.getKey();
                Entity entity = level.getEntity(familiarId);
                if (!(entity instanceof AbstractSpellCastingPet) || (familiar = (AbstractSpellCastingPet)entity).getSummoner() == null || !familiar.getSummoner().is((Entity)player)) continue;
                FamiliarManager.updateFamiliarData(familiar);
                actualSummonedFamiliars.add(familiarId);
                ++updatedCount;
                FamiliarsLib.LOGGER.debug("Updated data for summoned familiar {}", (Object)familiarId);
            }
            familiarData.getSummonedFamiliarIds().clear();
            for (UUID summonedId : actualSummonedFamiliars) {
                familiarData.addSummonedFamiliar(summonedId);
            }
            if (updatedCount > 0) {
                FamiliarsLib.LOGGER.debug("Updated data for {} summoned familiars before opening screen", (Object)updatedCount);
            }
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error updating summoned familiars data: ", (Throwable)e);
        }
    }

    public static void cleanupSummonedFamiliarsOnDimensionChange(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        familiarData.clearAllSummoned();
        FamiliarsLib.LOGGER.debug("Cleared summoned familiars for player {} on dimension change", (Object)player.getName().getString());
    }

    public static Set<UUID> getSummonedFamiliarIds(ServerPlayer player) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getSummonedFamiliarIds();
    }

    public static boolean isFamiliarSummoned(ServerPlayer player, UUID familiarId) {
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.isFamiliarSummoned(familiarId);
    }

    public static void handleMoveFamiliar(ServerPlayer player, BlockPos blockPos, UUID familiarId, boolean toStorage) {
        BlockEntity blockEntity = player.level().getBlockEntity(blockPos);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        if (!storageEntity.isOwner(player)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_storage_owner").withStyle(ChatFormatting.RED)));
            return;
        }
        if (!storageEntity.isStoreMode()) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.only_store_mode").withStyle(ChatFormatting.RED)));
            return;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (toStorage) {
            boolean success;
            ServerLevel serverLevel;
            Entity entity;
            if (!familiarData.hasFamiliar(familiarId)) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_not_found").withStyle(ChatFormatting.RED)));
                return;
            }
            CompoundTag familiarNBT = familiarData.getFamiliarData(familiarId);
            if (familiarNBT == null) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_data_error").withStyle(ChatFormatting.RED)));
                return;
            }
            Level level = player.level();
            if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(familiarId)) instanceof AbstractSpellCastingPet) {
                AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
                FamiliarManager.desummonSpecificFamiliar(player, familiarId);
            }
            if (success = storageEntity.storeFamiliar(familiarId, familiarNBT, player)) {
                if (FamiliarsLib.isModLoaded("alshanex_familiars")) {
                    try {
                        Class<?> clazz = Class.forName("net.alshanex.alshanex_familiars.util.familiars.AlshanexFamiliarsManager");
                        Method method = clazz.getMethod("cleanFamiliarFromPandoraBox", ServerPlayer.class, UUID.class);
                        method.invoke(null, player, familiarId);
                    }
                    catch (Exception e) {
                        FamiliarsLib.LOGGER.error("Error calling cleanFamiliarFromPandoraBox: ", (Throwable)e);
                    }
                }
                String familiarName = FamiliarManager.getFamiliarName(familiarNBT);
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_stored", (Object[])new Object[]{familiarName}).withStyle(ChatFormatting.GREEN)));
                FamiliarManager.syncFamiliarDataForPlayer(player);
            } else {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.storage_full").withStyle(ChatFormatting.RED)));
            }
        } else {
            Map<UUID, CompoundTag> storedFamiliars = storageEntity.getStoredFamiliars();
            if (!storedFamiliars.containsKey(familiarId)) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_not_in_storage").withStyle(ChatFormatting.RED)));
                return;
            }
            if (!familiarData.canTameMoreFamiliars()) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.player_familiar_limit").withStyle(ChatFormatting.RED)));
                return;
            }
            CompoundTag familiarNBT = storedFamiliars.get(familiarId);
            boolean success = storageEntity.retrieveFamiliar(familiarId, player);
            if (success) {
                String familiarName = FamiliarManager.getFamiliarName(familiarNBT);
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.familiar_retrieved", (Object[])new Object[]{familiarName}).withStyle(ChatFormatting.GREEN)));
                FamiliarManager.syncFamiliarDataForPlayer(player);
            } else {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.retrieval_failed").withStyle(ChatFormatting.RED)));
            }
        }
        Map<UUID, CompoundTag> updatedStoredData = storageEntity.getStoredFamiliars();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateFamiliarStoragePacket(blockPos, updatedStoredData, storageEntity.isStoreMode(), storageEntity.canFamiliarsUseGoals(), storageEntity.getMaxDistance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static String getFamiliarName(CompoundTag familiarNBT) {
        if (familiarNBT.contains("customName")) {
            return familiarNBT.getString("customName");
        }
        String entityTypeString = familiarNBT.getString("id");
        String[] parts = entityTypeString.split(":");
        if (parts.length > 1) {
            return parts[1].replace("_", " ");
        }
        return entityTypeString.substring(entityTypeString.lastIndexOf(58) + 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleStorageUpdate(BlockPos blockPos, Map<UUID, CompoundTag> storedFamiliars, boolean storeMode, boolean canFamiliarsUseGoals, int maxDistance) {
        BlockEntity blockEntity;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && (blockEntity = minecraft.level.getBlockEntity(blockPos)) instanceof AbstractFamiliarStorageBlockEntity) {
            AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
            storageEntity.storedFamiliars.clear();
            for (Map.Entry<UUID, CompoundTag> entry : storedFamiliars.entrySet()) {
                storageEntity.storedFamiliars.put(entry.getKey(), new AbstractFamiliarStorageBlockEntity.FamiliarData(entry.getValue(), 0));
            }
            storageEntity.setClientStoreMode(storeMode);
            storageEntity.setClientCanFamiliarsUseGoals(canFamiliarsUseGoals);
            storageEntity.setClientMaxDistance(maxDistance);
            FamiliarsLib.LOGGER.debug("Received storage update for position {} with {} stored familiars, mode: {}, goals: {}, distance: {}", new Object[]{blockPos, storedFamiliars.size(), storeMode ? "Store" : "Wander", canFamiliarsUseGoals, maxDistance});
            Screen screen = minecraft.screen;
            if (screen instanceof FamiliarStorageScreen) {
                FamiliarStorageScreen storageScreen = (FamiliarStorageScreen)screen;
                storageScreen.reloadFamiliarData();
            }
        }
    }

    public static boolean storeFamiliarInHouse(UUID familiarId, CompoundTag familiarData, ServerPlayer player, BlockPos storagePos) {
        ServerLevel serverLevel;
        Entity entity;
        BlockEntity blockEntity = player.level().getBlockEntity(storagePos);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return false;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        if (!storageEntity.isOwner(player)) {
            return false;
        }
        PlayerFamiliarData playerData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        BedLinkData bedLinkData = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
        AbstractFamiliarStorageBlockEntity.FamiliarData data = new AbstractFamiliarStorageBlockEntity.FamiliarData(familiarData, 0);
        storageEntity.storedFamiliars.put(familiarId, data);
        storageEntity.outsideFamiliars.remove(familiarId);
        Level level = player.level();
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(familiarId)) instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            familiar.setIsInHouse(true, storagePos);
            FamiliarManager.desummonSpecificFamiliar(player, familiarId);
        }
        playerData.removeTamedFamiliar(familiarId);
        bedLinkData.unlinkFamiliar(familiarId);
        storageEntity.setChanged();
        storageEntity.syncToClient();
        FamiliarsLib.LOGGER.debug("Stored familiar {} in house at {}", (Object)familiarId, (Object)storagePos);
        return true;
    }

    public static boolean retrieveFamiliarFromHouse(UUID familiarId, ServerPlayer player, BlockPos storagePos) {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        BlockEntity blockEntity = player.level().getBlockEntity(storagePos);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return false;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        if (!storageEntity.isOwner(player)) {
            return false;
        }
        PlayerFamiliarData playerData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (!playerData.canTameMoreFamiliars()) {
            return false;
        }
        AbstractFamiliarStorageBlockEntity.FamiliarData familiarData = storageEntity.storedFamiliars.remove(familiarId);
        storageEntity.outsideFamiliars.remove(familiarId);
        CompoundTag nbtData = familiarData.nbtData.copy();
        nbtData.putBoolean("isInHouse", false);
        playerData.addTamedFamiliar(familiarId, nbtData);
        if (playerData.getSelectedFamiliarId() == null) {
            playerData.setSelectedFamiliarId(familiarId);
        }
        if ((level = player.level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(familiarId)) instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            familiar.setIsInHouse(false, null);
            familiar.remove(Entity.RemovalReason.DISCARDED);
            FamiliarsLib.LOGGER.debug("Removed familiar {} from world as it was retrieved", (Object)familiarId);
        }
        storageEntity.setChanged();
        storageEntity.syncToClient();
        FamiliarsLib.LOGGER.debug("Retrieved familiar {} from house at {}", (Object)familiarId, (Object)storagePos);
        return true;
    }

    public static void handleSetStorageMode(ServerPlayer player, BlockPos blockPos, boolean storeMode) {
        BlockEntity blockEntity = player.level().getBlockEntity(blockPos);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        if (!storageEntity.isOwner(player)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_storage_owner").withStyle(ChatFormatting.RED)));
            return;
        }
        storageEntity.setStoreMode(storeMode);
        String modeDescription = storeMode ? "ui.familiarslib.familiar_storage_screen.store_mode_message" : "ui.familiarslib.familiar_storage_screen.wander_mode_message";
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)modeDescription).withStyle(storeMode ? ChatFormatting.GREEN : ChatFormatting.YELLOW)));
        Map<UUID, CompoundTag> storedData = storageEntity.getStoredFamiliars();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateFamiliarStoragePacket(blockPos, storedData, storeMode, storageEntity.canFamiliarsUseGoals(), storageEntity.getMaxDistance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleUpdateStorageSettings(ServerPlayer player, BlockPos blockPos, boolean canFamiliarsUseGoals, int maxDistance) {
        BlockEntity blockEntity = player.level().getBlockEntity(blockPos);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        if (!storageEntity.isOwner(player)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_storage_owner").withStyle(ChatFormatting.RED)));
            return;
        }
        storageEntity.setCanFamiliarsUseGoals(canFamiliarsUseGoals);
        storageEntity.setMaxDistance(maxDistance);
        FamiliarsLib.LOGGER.debug("Updated storage settings for player {}: goals={}, distance={}", new Object[]{player.getName().getString(), canFamiliarsUseGoals, maxDistance});
        Map<UUID, CompoundTag> storedData = storageEntity.getStoredFamiliars();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateFamiliarStoragePacket(blockPos, storedData, storageEntity.isStoreMode(), canFamiliarsUseGoals, maxDistance), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

