/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarStorageBlockEntity;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class FamiliarHelper {
    public static void attemptLegacyMigration(ServerPlayer player, AbstractSpellCastingPet familiar) {
        try {
            PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            UUID familiarId = familiar.getUUID();
            if (!familiarData.hasFamiliar(familiarId)) {
                FamiliarsLib.LOGGER.debug("Migrating legacy familiar {} for player {}", (Object)familiarId, (Object)player.getName().getString());
                CompoundTag familiarNBT = FamiliarHelper.createFamiliarNBT(familiar);
                if (familiarData.tryAddTamedFamiliar(familiarId, familiarNBT)) {
                    if (familiarData.getSelectedFamiliarId() == null) {
                        familiarData.setSelectedFamiliarId(familiarId);
                        FamiliarsLib.LOGGER.debug("Set migrated familiar {} as selected", (Object)familiarId);
                    }
                    familiarData.setCurrentSummonedFamiliarId(familiarId);
                    FamiliarManager.syncFamiliarDataForPlayer(player);
                    FamiliarsLib.LOGGER.debug("Successfully migrated legacy familiar {} to data attachment", (Object)familiarId);
                } else {
                    FamiliarsLib.LOGGER.debug("Failed to migrate legacy familiar {} - player {} at max capacity ({}/{})", new Object[]{familiarId, player.getName().getString(), familiarData.getFamiliarCount(), 10});
                }
            } else if (!familiarId.equals(familiarData.getCurrentSummonedFamiliarId())) {
                familiarData.setCurrentSummonedFamiliarId(familiarId);
                FamiliarManager.syncFamiliarDataForPlayer(player);
            }
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error during legacy familiar migration for {}: ", (Object)familiar.getUUID(), (Object)e);
        }
    }

    private static CompoundTag createFamiliarNBT(AbstractSpellCastingPet familiar) {
        CompoundTag nbt = new CompoundTag();
        familiar.saveWithoutId(nbt);
        nbt.putFloat("currentHealth", familiar.getHealth());
        String entityTypeId = EntityType.getKey((EntityType)familiar.getType()).toString();
        nbt.putString("id", entityTypeId);
        nbt.putInt("armorStacks", familiar.getArmorStacks().intValue());
        nbt.putInt("enragedStacks", familiar.getEnragedStacks().intValue());
        nbt.putBoolean("canBlock", familiar.getIsBlocking().booleanValue());
        if (familiar.hasCustomName()) {
            nbt.putString("customName", familiar.getCustomName().getString());
        }
        return nbt;
    }

    public static void spawnTamingParticles(boolean tamed, AbstractSpellCastingPet familiar) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        int count = 16;
        float radius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)familiar.level(), (ParticleOptions)particleoptions, (double)(familiar.position().x + x), (double)familiar.position().y, (double)(familiar.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public static void spawnEatingParticles(AbstractSpellCastingPet familiar) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        int count = 3;
        float radius = 0.5f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)familiar.level(), (ParticleOptions)particleoptions, (double)(familiar.position().x + x), (double)familiar.position().y, (double)(familiar.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public static boolean canDropItem(ServerLevel level, Entity entity, Item searchItem) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ResourceKey lootTableId = livingEntity.getLootTable();
        if (lootTableId == null) {
            return false;
        }
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
        LootParams params = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic()).create(LootContextParamSets.ENTITY);
        ObjectArrayList generatedItems = lootTable.getRandomItems(params);
        return generatedItems.stream().anyMatch(stack -> stack.getItem() == searchItem);
    }

    public static void handleHouseBehavior(AbstractSpellCastingPet familiar) {
        if (familiar.housePosition == null) {
            return;
        }
        BlockEntity blockEntity = familiar.level().getBlockEntity(familiar.housePosition);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            familiar.setIsInHouse(false, null);
            familiar.remove(Entity.RemovalReason.DISCARDED);
            FamiliarsLib.LOGGER.debug("House destroyed, removing familiar {}", (Object)familiar.getUUID());
            return;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        double distanceToHouse = familiar.position().distanceTo(Vec3.atCenterOf((Vec3i)familiar.housePosition));
        if (distanceToHouse > 35.0 && familiar.tickCount % 20 == 0) {
            FamiliarsLib.LOGGER.debug("Familiar {} too far from house, attempting to return", (Object)familiar.getUUID());
            storageEntity.tryRecallFamiliar(familiar);
        }
        if (familiar.tickCount % 400 == 0 && familiar.level().random.nextFloat() < 0.1f) {
            storageEntity.tryRecallFamiliar(familiar);
        }
        if (familiar.getHealth() < familiar.getMaxHealth() * 0.3f) {
            storageEntity.tryRecallFamiliar(familiar);
        }
        if ((familiar.level().isNight() || familiar.level().isRaining()) && familiar.level().random.nextFloat() < 0.2f) {
            storageEntity.tryRecallFamiliar(familiar);
        }
    }
}

