/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.AbstractFamiliarBedBlock;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarBedBlockEntity;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarStorageBlockEntity;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.util.CylinderParticleManager;
import net.alshanex.familiarslib.util.ModTags;
import net.alshanex.familiarslib.util.familiars.FamiliarBedHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FamiliarGoals {

    public static class StayNearHouseGoal
    extends Goal {
        private final AbstractSpellCastingPet familiar;
        private final BlockPos housePos;
        private final double maxDistance;

        public StayNearHouseGoal(AbstractSpellCastingPet familiar, BlockPos housePos, double maxDistance) {
            this.familiar = familiar;
            this.housePos = housePos;
            this.maxDistance = maxDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            BlockEntity blockEntity = this.familiar.level().getBlockEntity(this.housePos);
            if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
                return false;
            }
            double distance = this.familiar.position().distanceTo(Vec3.atCenterOf((Vec3i)this.housePos));
            return distance > this.maxDistance;
        }

        public boolean canContinueToUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            double distance = this.familiar.position().distanceTo(Vec3.atCenterOf((Vec3i)this.housePos));
            return distance > this.maxDistance * 0.8 && this.familiar.getNavigation().isInProgress();
        }

        public void start() {
            Vec3 houseCenter = Vec3.atCenterOf((Vec3i)this.housePos);
            Vec3 currentPos = this.familiar.position();
            Vec3 direction = houseCenter.subtract(currentPos).normalize();
            double offsetX = (this.familiar.getRandom().nextDouble() - 0.5) * 6.0;
            double offsetZ = (this.familiar.getRandom().nextDouble() - 0.5) * 6.0;
            Vec3 targetPos = currentPos.add(direction.scale(8.0)).add(offsetX, 0.0, offsetZ);
            PathNavigation navigation = this.familiar.getNavigation();
            navigation.moveTo(targetPos.x, targetPos.y, targetPos.z, 1.2);
        }
    }

    public static class CasualRandomLookGoal
    extends Goal {
        private final AbstractSpellCastingPet familiar;
        private double relX;
        private double relZ;
        private int lookTime;

        public CasualRandomLookGoal(AbstractSpellCastingPet familiar) {
            this.familiar = familiar;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            return this.familiar.getRandom().nextFloat() < 0.02f;
        }

        public boolean canContinueToUse() {
            return this.familiar.getIsInHouse() != false && this.lookTime >= 0;
        }

        public void start() {
            double angle = Math.random() * 2.0 * Math.PI;
            this.relX = Math.cos(angle);
            this.relZ = Math.sin(angle);
            this.lookTime = 20 + this.familiar.getRandom().nextInt(20);
        }

        public void tick() {
            --this.lookTime;
            this.familiar.getLookControl().setLookAt(this.familiar.getX() + this.relX, this.familiar.getEyeY(), this.familiar.getZ() + this.relZ);
        }
    }

    public static class CasualLookAtPlayerGoal
    extends Goal {
        private final AbstractSpellCastingPet familiar;
        private final Class<? extends LivingEntity> lookAtType;
        private final float lookDistance;
        private LivingEntity lookAt;
        private int lookTime;

        public CasualLookAtPlayerGoal(AbstractSpellCastingPet familiar, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            this.familiar = familiar;
            this.lookAtType = lookAtType;
            this.lookDistance = lookDistance;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            if (this.familiar.getRandom().nextInt(80) != 0) {
                return false;
            }
            this.lookAt = this.familiar.level().getNearestEntity(this.lookAtType, TargetingConditions.forNonCombat().range((double)this.lookDistance), (LivingEntity)this.familiar, this.familiar.getX(), this.familiar.getEyeY(), this.familiar.getZ(), this.familiar.getBoundingBox().inflate((double)this.lookDistance, 3.0, (double)this.lookDistance));
            return this.lookAt != null;
        }

        public boolean canContinueToUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            if (!this.lookAt.isAlive()) {
                return false;
            }
            if (this.familiar.distanceToSqr((Entity)this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0;
        }

        public void start() {
            this.lookTime = this.adjustedTickDelay(40 + this.familiar.getRandom().nextInt(40));
        }

        public void stop() {
            this.lookAt = null;
        }

        public void tick() {
            if (this.lookAt != null) {
                this.familiar.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY(), this.lookAt.getZ());
            }
            --this.lookTime;
        }
    }

    public static class WanderAroundHouseGoal
    extends Goal {
        private final AbstractSpellCastingPet familiar;
        private final BlockPos housePos;
        private final double wanderRadius;
        private final double speedModifier;
        private Vec3 targetPos;
        private int cooldown = 0;

        public WanderAroundHouseGoal(AbstractSpellCastingPet familiar, BlockPos housePos, double wanderRadius, double speedModifier) {
            this.familiar = familiar;
            this.housePos = housePos;
            this.wanderRadius = wanderRadius;
            this.speedModifier = speedModifier;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            BlockEntity blockEntity = this.familiar.level().getBlockEntity(this.housePos);
            if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return !this.familiar.getNavigation().isInProgress() && this.familiar.getRandom().nextInt(60) == 0;
        }

        public boolean canContinueToUse() {
            if (!this.familiar.getIsInHouse().booleanValue()) {
                return false;
            }
            double distanceToHouse = this.familiar.position().distanceTo(Vec3.atCenterOf((Vec3i)this.housePos));
            if (distanceToHouse > this.wanderRadius + 5.0) {
                return false;
            }
            return this.familiar.getNavigation().isInProgress() && this.targetPos != null;
        }

        public void start() {
            Vec3 houseCenter = Vec3.atCenterOf((Vec3i)this.housePos);
            Vec3 currentPos = this.familiar.position();
            for (int attempt = 0; attempt < 10; ++attempt) {
                double angle = this.familiar.getRandom().nextDouble() * 2.0 * Math.PI;
                double distance = 3.0 + this.familiar.getRandom().nextDouble() * (this.wanderRadius - 3.0);
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                this.targetPos = houseCenter.add(offsetX, 0.0, offsetZ);
                if (currentPos.distanceTo(this.targetPos) > 2.0) break;
            }
            if (this.targetPos != null) {
                this.targetPos = this.findGroundPosition(this.targetPos);
                PathNavigation navigation = this.familiar.getNavigation();
                boolean success = navigation.moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z, this.speedModifier);
                if (!success) {
                    Vec3 closerPos = houseCenter.add((this.targetPos.x - houseCenter.x) * 0.5, 0.0, (this.targetPos.z - houseCenter.z) * 0.5);
                    closerPos = this.findGroundPosition(closerPos);
                    navigation.moveTo(closerPos.x, closerPos.y, closerPos.z, this.speedModifier);
                }
            }
            this.cooldown = 40 + this.familiar.getRandom().nextInt(40);
        }

        public void stop() {
            this.targetPos = null;
            this.familiar.getNavigation().stop();
        }

        private Vec3 findGroundPosition(Vec3 pos) {
            BlockPos checkPos;
            int y;
            BlockPos blockPos = BlockPos.containing((Position)pos);
            for (y = 0; y <= 5; ++y) {
                checkPos = blockPos.offset(0, -y, 0);
                if (!this.familiar.level().getBlockState(checkPos).isSolid() || !this.familiar.level().getBlockState(checkPos.above()).isAir()) continue;
                return Vec3.atBottomCenterOf((Vec3i)checkPos.above());
            }
            for (y = 1; y <= 3; ++y) {
                checkPos = blockPos.offset(0, y, 0);
                if (!this.familiar.level().getBlockState(checkPos).isSolid() || !this.familiar.level().getBlockState(checkPos.above()).isAir()) continue;
                return Vec3.atBottomCenterOf((Vec3i)checkPos.above());
            }
            return pos;
        }
    }

    public static class DisableSculkShriekerGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int radius;

        public DisableSculkShriekerGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int radius) {
            this.controllerEntity = controllerEntity;
            this.targetEntity = targetEntity;
            this.radius = radius;
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            if (!this.controllerEntity.canExecuteGoalsInHouse()) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            LivingEntity owner = this.targetEntity.get();
            BlockPos controllerPos = owner.blockPosition();
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int y = -this.radius; y <= this.radius; ++y) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        BlockPos currentPos = controllerPos.offset(x, y, z);
                        BlockState blockState = this.controllerEntity.level().getBlockState(currentPos);
                        if (!blockState.is(Blocks.SCULK_SHRIEKER) || !((Boolean)blockState.getValue((Property)SculkShriekerBlock.SHRIEKING)).booleanValue()) continue;
                        this.controllerEntity.triggerAnim("interact_controller", "interact");
                        CylinderParticleManager.spawnParticlesAtBlockPos(owner.level(), currentPos.getCenter(), 50, (ParticleOptions)ParticleRegistry.FIREFLY_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.5, 0.0, 0.0);
                        this.controllerEntity.level().setBlock(currentPos, (BlockState)blockState.setValue((Property)SculkShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
            }
        }

        public boolean canContinueToUse() {
            return this.canUse() && this.controllerEntity.canExecuteGoalsInHouse();
        }
    }

    public static class WitherifyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Skeleton skeleton;

        public WitherifyGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.skeleton != null) {
                return false;
            }
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (!this.pet.canExecuteGoalsInHouse()) {
                return false;
            }
            this.skeleton = this.pet.level().getEntitiesOfClass(Skeleton.class, this.pet.getBoundingBox().inflate(15.0)).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.skeleton != null;
        }

        public boolean canContinueToUse() {
            return this.skeleton != null && this.skeleton.isAlive() && this.pet.canExecuteGoalsInHouse();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.skeleton, 1.0);
        }

        public void tick() {
            if (this.skeleton == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.skeleton) < 3.0) {
                this.pet.getLookControl().setLookAt((Entity)this.skeleton, 10.0f, 10.0f);
                this.pet.triggerAnim("interact_controller", "interact");
                WitherSkeleton witherSkeleton = new WitherSkeleton(EntityType.WITHER_SKELETON, this.pet.level());
                witherSkeleton.setPos(this.skeleton.getX(), this.skeleton.getY(), this.skeleton.getZ());
                witherSkeleton.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.pet.level()), this.pet.level.getCurrentDifficultyAt(this.skeleton.getOnPos()), MobSpawnType.MOB_SUMMONED, null);
                this.pet.level().addFreshEntity((Entity)witherSkeleton);
                MagicManager.spawnParticles((Level)this.pet.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.skeleton.getX(), (double)(this.skeleton.getY() + (double)0.165f), (double)this.skeleton.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                this.skeleton.remove(Entity.RemovalReason.DISCARDED);
            } else {
                this.pet.getNavigation().moveTo((Entity)this.skeleton, 1.0);
            }
        }

        public void stop() {
            this.skeleton = null;
        }
    }

    public static class ThunderstrikeGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Creeper creeper;

        public ThunderstrikeGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.creeper != null) {
                return false;
            }
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (!this.pet.canExecuteGoalsInHouse()) {
                return false;
            }
            this.creeper = this.pet.level().getEntitiesOfClass(Creeper.class, this.pet.getBoundingBox().inflate(15.0), creeper -> !creeper.isPowered()).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.creeper != null;
        }

        public boolean canContinueToUse() {
            return this.creeper != null && this.creeper.isAlive() && !this.creeper.isPowered() && this.pet.canExecuteGoalsInHouse();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.creeper, 1.0);
        }

        public void tick() {
            if (this.creeper == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.creeper) < 8.0) {
                Level level;
                this.pet.getLookControl().setLookAt((Entity)this.creeper, 10.0f, 10.0f);
                if (!this.creeper.isPowered() && (level = this.pet.level) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.pet.triggerAnim("interact_controller", "interact");
                    LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.pet.level);
                    lightningBolt.setVisualOnly(true);
                    lightningBolt.setDamage(0.0f);
                    lightningBolt.setPos(this.creeper.getX(), this.creeper.getY(), this.creeper.getZ());
                    this.pet.level.addFreshEntity((Entity)lightningBolt);
                    this.creeper.thunderHit(serverLevel, lightningBolt);
                }
            } else {
                this.pet.getNavigation().moveTo((Entity)this.creeper, 1.0);
            }
        }

        public void stop() {
            this.creeper = null;
        }
    }

    public static class TargetAttackerOfPlayersGoal
    extends TargetGoal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<LivingEntity> owner;
        private LivingEntity target;

        public TargetAttackerOfPlayersGoal(AbstractSpellCastingPet pet, Supplier<LivingEntity> owner) {
            super((Mob)pet, true);
            this.pet = pet;
            this.owner = owner;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity getOwner = this.owner.get();
            if (getOwner == null) {
                return false;
            }
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (!this.pet.canExecuteGoalsInHouse()) {
                return false;
            }
            Level level = this.pet.level();
            List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(15.0), entity -> {
                Mob mob;
                return entity instanceof Mob && (mob = (Mob)entity).getTarget() == getOwner;
            });
            if (!nearbyEntities.isEmpty()) {
                this.target = (LivingEntity)nearbyEntities.getFirst();
                return true;
            }
            return false;
        }

        public void start() {
            this.pet.setTarget(this.target);
            this.pet.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)this.target, 200L);
            super.start();
        }
    }

    public static class MovementAwareRandomLookAroundGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private double relX;
        private double relZ;
        private int lookTime;

        public MovementAwareRandomLookAroundGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            return this.pet.getRandom().nextFloat() < 0.02f;
        }

        public boolean canContinueToUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            return this.lookTime >= 0;
        }

        public void start() {
            double d0 = Math.PI * 2 * this.pet.getRandom().nextDouble();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = 20 + this.pet.getRandom().nextInt(20);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.lookTime;
            this.pet.getLookControl().setLookAt(this.pet.getX() + this.relX, this.pet.getEyeY(), this.pet.getZ() + this.relZ);
        }
    }

    public static class MovementAwareLookAtPlayerGoal
    extends Goal {
        public static final float DEFAULT_PROBABILITY = 0.02f;
        private final AbstractSpellCastingPet pet;
        @Nullable
        protected Entity lookAt;
        protected final float lookDistance;
        private int lookTime;
        protected final float probability;
        private final boolean onlyHorizontal;
        protected final Class<? extends LivingEntity> lookAtType;
        protected final TargetingConditions lookAtContext;

        public MovementAwareLookAtPlayerGoal(AbstractSpellCastingPet pet, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            this(pet, lookAtType, lookDistance, 0.02f);
        }

        public MovementAwareLookAtPlayerGoal(AbstractSpellCastingPet pet, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability) {
            this(pet, lookAtType, lookDistance, probability, false);
        }

        public MovementAwareLookAtPlayerGoal(AbstractSpellCastingPet pet, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability, boolean onlyHorizontal) {
            this.pet = pet;
            this.lookAtType = lookAtType;
            this.lookDistance = lookDistance;
            this.probability = probability;
            this.onlyHorizontal = onlyHorizontal;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
            this.lookAtContext = lookAtType == Player.class ? TargetingConditions.forNonCombat().range((double)lookDistance).selector(p_25531_ -> EntitySelector.notRiding((Entity)pet).test(p_25531_)) : TargetingConditions.forNonCombat().range((double)lookDistance);
        }

        public boolean canUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (this.pet.getRandom().nextFloat() >= this.probability) {
                return false;
            }
            if (this.pet.getTarget() != null) {
                this.lookAt = this.pet.getTarget();
            }
            this.lookAt = this.lookAtType == Player.class ? this.pet.level().getNearestPlayer(this.lookAtContext, (LivingEntity)this.pet, this.pet.getX(), this.pet.getEyeY(), this.pet.getZ()) : this.pet.level().getNearestEntity(this.pet.level().getEntitiesOfClass(this.lookAtType, this.pet.getBoundingBox().inflate((double)this.lookDistance, 3.0, (double)this.lookDistance), p_148124_ -> true), this.lookAtContext, (LivingEntity)this.pet, this.pet.getX(), this.pet.getEyeY(), this.pet.getZ());
            return this.lookAt != null;
        }

        public boolean canContinueToUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (!this.lookAt.isAlive()) {
                return false;
            }
            return this.pet.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance) ? false : this.lookTime > 0;
        }

        public void start() {
            this.lookTime = this.adjustedTickDelay(40 + this.pet.getRandom().nextInt(40));
        }

        public void stop() {
            this.lookAt = null;
        }

        public void tick() {
            if (this.lookAt.isAlive()) {
                double d0 = this.onlyHorizontal ? this.pet.getEyeY() : this.lookAt.getEyeY();
                this.pet.getLookControl().setLookAt(this.lookAt.getX(), d0, this.lookAt.getZ());
                --this.lookTime;
            }
        }
    }

    public static class MovementAwareFollowOwnerGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        @Nullable
        private LivingEntity owner;
        private Supplier<LivingEntity> ownerGetter;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private float teleportDistance;
        private boolean canFly;

        public MovementAwareFollowOwnerGoal(AbstractSpellCastingPet pet, Supplier<LivingEntity> ownerGetter, double speedModifier, float startDistance, float stopDistance, boolean canFly, float teleportDistance) {
            this.pet = pet;
            this.ownerGetter = ownerGetter;
            this.speedModifier = speedModifier;
            this.navigation = pet.getNavigation();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.teleportDistance = teleportDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.canFly = canFly;
        }

        public boolean canUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.pet.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            if (this.pet.getIsInHouse().booleanValue()) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (this.navigation.isDone()) {
                return false;
            }
            return !(this.pet.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.pet.getPathfindingMalus(PathType.WATER);
            this.pet.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.owner = null;
            this.navigation.stop();
            this.pet.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            boolean flag = this.shouldTryTeleportToOwner();
            if (!flag) {
                this.pet.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.pet.getMaxHeadXRot());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (flag) {
                    this.tryToTeleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }

        public void tryToTeleportToOwner() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity != null) {
                this.teleportToAroundBlockPos(livingentity.blockPosition());
            }
        }

        public boolean shouldTryTeleportToOwner() {
            LivingEntity livingentity = this.ownerGetter.get();
            return livingentity != null && this.pet.distanceToSqr((Entity)livingentity) >= (double)(this.teleportDistance * this.teleportDistance);
        }

        private void teleportToAroundBlockPos(BlockPos pPos) {
            for (int i = 0; i < 10; ++i) {
                int j = this.pet.getRandom().nextIntBetweenInclusive(-3, 3);
                int k = this.pet.getRandom().nextIntBetweenInclusive(-3, 3);
                if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
                int l = this.pet.getRandom().nextIntBetweenInclusive(-1, 1);
                if (!this.maybeTeleportTo(pPos.getX() + j, pPos.getY() + l, pPos.getZ() + k)) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int pX, int pY, int pZ) {
            if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
                return false;
            }
            this.pet.moveTo((double)pX + 0.5, pY, (double)pZ + 0.5, this.pet.getYRot(), this.pet.getXRot());
            this.navigation.stop();
            return true;
        }

        private boolean canTeleportTo(BlockPos pPos) {
            PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this.pet, (BlockPos)pPos);
            if (pathtype != PathType.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.pet.level().getBlockState(pPos.below());
            if (!this.canFly && blockstate.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pPos.subtract((Vec3i)this.pet.blockPosition());
            return this.pet.level().noCollision((Entity)this.pet, this.pet.getBoundingBox().move(blockpos));
        }
    }

    public static class StealItemsWhenNotWatchedGoal
    extends Goal {
        private final AbstractSpellCastingPet mob;
        private final double searchRadius;
        private ItemEntity targetItem;
        private int stealingTime;
        private final int STEALING_DURATION = 20;

        public StealItemsWhenNotWatchedGoal(AbstractSpellCastingPet mob, double searchRadius) {
            this.mob = mob;
            this.searchRadius = searchRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.mob.getIsSitting().booleanValue()) {
                return false;
            }
            if (this.mob.getMovementDisabled()) {
                return false;
            }
            List nearbyItems = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(this.searchRadius), this::isDesirableItem);
            if (nearbyItems.isEmpty()) {
                return false;
            }
            if (this.isAnyPlayerWatching()) {
                return false;
            }
            this.targetItem = (ItemEntity)nearbyItems.get(0);
            double closestDistance = this.mob.distanceToSqr((Entity)this.targetItem);
            for (int i = 1; i < nearbyItems.size(); ++i) {
                ItemEntity item = (ItemEntity)nearbyItems.get(i);
                double distance = this.mob.distanceToSqr((Entity)item);
                if (!(distance < closestDistance)) continue;
                this.targetItem = item;
                closestDistance = distance;
            }
            return true;
        }

        public void start() {
            this.stealingTime = 0;
        }

        public boolean canContinueToUse() {
            return this.targetItem != null && this.targetItem.isAlive() && !this.isAnyPlayerWatching() && this.stealingTime < 20;
        }

        public void tick() {
            this.mob.getLookControl().setLookAt(this.targetItem.getX(), this.targetItem.getY(), this.targetItem.getZ());
            ++this.stealingTime;
            if (this.stealingTime >= 20) {
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.0f);
                this.targetItem.discard();
                this.targetItem = null;
            }
        }

        public void stop() {
            this.targetItem = null;
            this.stealingTime = 0;
        }

        private boolean isDesirableItem(ItemEntity itemEntity) {
            return itemEntity != null && itemEntity.isAlive() && itemEntity.getItem().is(ModTags.ILLUSIONIST_STEALS);
        }

        private boolean isAnyPlayerWatching() {
            List nearbyPlayers = this.mob.level().getEntitiesOfClass(Player.class, new AABB(this.mob.getX() - 16.0, this.mob.getY() - 16.0, this.mob.getZ() - 16.0, this.mob.getX() + 16.0, this.mob.getY() + 16.0, this.mob.getZ() + 16.0));
            for (Player player : nearbyPlayers) {
                if (!player.isAlive() || player.isSpectator() || !this.isInPlayerFieldOfView(player)) continue;
                return true;
            }
            return false;
        }

        private boolean isInPlayerFieldOfView(Player player) {
            Vec3 playerViewVector = player.getViewVector(1.0f).normalize();
            Vec3 playerToMobVector = new Vec3(this.mob.getX() - player.getX(), this.mob.getEyeY() - player.getEyeY(), this.mob.getZ() - player.getZ());
            double distanceSquared = playerToMobVector.lengthSqr();
            playerToMobVector = playerToMobVector.normalize();
            if (distanceSquared < 4.0) {
                return true;
            }
            double dotProduct = playerViewVector.dot(playerToMobVector);
            return dotProduct > -0.1 && player.hasLineOfSight((Entity)this.mob);
        }
    }

    public static class TeleportToOwnerGoal
    extends Goal {
        private final AbstractSpellCastingPet mob;
        @javax.annotation.Nullable
        private LivingEntity owner;
        private Supplier<LivingEntity> ownerGetter;
        private float teleportDistance;
        private Vec3 lastOwnerPosition = Vec3.ZERO;
        private int ticksSinceLastCheck = 0;
        private static final int CHECK_INTERVAL = 10;
        private static final double INSTANT_TELEPORT_THRESHOLD = 20.0;
        private static final int SAFE_POSITION_SEARCH_RADIUS = 16;

        public TeleportToOwnerGoal(AbstractSpellCastingPet pTamable, Supplier<LivingEntity> ownerGetter, float teleportDistance) {
            this.mob = pTamable;
            this.ownerGetter = ownerGetter;
            this.teleportDistance = teleportDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.hasOwnerTeleportedInstantly(livingentity)) {
                this.owner = livingentity;
                return true;
            }
            if (this.mob.distanceToSqr((Entity)livingentity) < (double)(this.teleportDistance * this.teleportDistance)) {
                return false;
            }
            if (this.mob.getIsSitting().booleanValue()) {
                return false;
            }
            if (this.mob.getIsInHouse().booleanValue()) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.hasOwnerTeleportedInstantly(livingentity) || this.shouldTryTeleportToOwner()) {
                return true;
            }
            return this.canUse();
        }

        public void tick() {
            boolean needsTeleport;
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return;
            }
            this.updateOwnerPositionTracking(livingentity);
            boolean bl = needsTeleport = this.shouldTryTeleportToOwner() || this.hasOwnerTeleportedInstantly(livingentity);
            if (!needsTeleport) {
                this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
            } else if (!this.tryToTeleportToOwnerSafely()) {
                this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
            }
        }

        private boolean hasOwnerTeleportedInstantly(LivingEntity owner) {
            ++this.ticksSinceLastCheck;
            if (this.ticksSinceLastCheck >= 10) {
                Vec3 currentOwnerPos = owner.position();
                if (this.lastOwnerPosition.equals((Object)Vec3.ZERO)) {
                    this.lastOwnerPosition = currentOwnerPos;
                    this.ticksSinceLastCheck = 0;
                    return false;
                }
                double distanceMoved = this.lastOwnerPosition.distanceTo(currentOwnerPos);
                boolean hasTeleported = distanceMoved > 20.0;
                this.lastOwnerPosition = currentOwnerPos;
                this.ticksSinceLastCheck = 0;
                return hasTeleported;
            }
            return false;
        }

        private void updateOwnerPositionTracking(LivingEntity owner) {
            if (this.ticksSinceLastCheck == 0) {
                this.lastOwnerPosition = owner.position();
            }
        }

        public boolean tryToTeleportToOwnerSafely() {
            BlockPos safePos;
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity != null && (safePos = this.findSafeTeleportPosition(livingentity.blockPosition(), this.mob.level())) != null && !safePos.equals((Object)livingentity.blockPosition())) {
                this.mob.moveTo((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5, this.mob.getYRot(), this.mob.getXRot());
                return true;
            }
            return false;
        }

        private BlockPos findSafeTeleportPosition(BlockPos ownerPos, Level level) {
            BlockPos nearbyPos = this.findSafeTeleportPositionAtLevel(ownerPos, level, 4);
            if (nearbyPos != null) {
                return nearbyPos;
            }
            for (int yOffset = -1; yOffset >= -32; --yOffset) {
                BlockPos safePos;
                BlockPos lowerPos = ownerPos.offset(0, yOffset, 0);
                if (!level.getBlockState(lowerPos.below()).isSolid() || (safePos = this.findSafeTeleportPositionAtLevel(lowerPos, level, 4)) == null) continue;
                return safePos;
            }
            return this.findSafeTeleportPositionExtended(ownerPos, level);
        }

        private BlockPos findSafeTeleportPositionAtLevel(BlockPos centerPos, Level level, int radius) {
            for (int i = 0; i < 10; ++i) {
                BlockPos testPos;
                int j = this.mob.getRandom().nextIntBetweenInclusive(-radius, radius);
                int k = this.mob.getRandom().nextIntBetweenInclusive(-radius, radius);
                if (Math.abs(j) < 2 && Math.abs(k) < 2 || !this.canTeleportTo(testPos = new BlockPos(centerPos.getX() + j, centerPos.getY(), centerPos.getZ() + k))) continue;
                return testPos;
            }
            for (int r = 1; r <= radius; ++r) {
                for (int angle = 0; angle < 8; ++angle) {
                    double radians = Math.PI * 2 * (double)angle / 8.0;
                    int x = centerPos.getX() + (int)(Math.cos(radians) * (double)r);
                    int z = centerPos.getZ() + (int)(Math.sin(radians) * (double)r);
                    BlockPos testPos = new BlockPos(x, centerPos.getY(), z);
                    if (!this.canTeleportTo(testPos)) continue;
                    return testPos;
                }
            }
            return null;
        }

        private BlockPos findSafeTeleportPositionExtended(BlockPos centerPos, Level level) {
            for (int radius = 1; radius <= 16; ++radius) {
                for (int angle = 0; angle < 16; ++angle) {
                    double radians = Math.PI * 2 * (double)angle / 16.0;
                    int x = centerPos.getX() + (int)(Math.cos(radians) * (double)radius);
                    int z = centerPos.getZ() + (int)(Math.sin(radians) * (double)radius);
                    for (int yOffset = 10; yOffset >= -10; --yOffset) {
                        BlockPos testPos = new BlockPos(x, centerPos.getY() + yOffset, z);
                        if (!this.canTeleportTo(testPos)) continue;
                        return testPos;
                    }
                }
            }
            return null;
        }

        public boolean shouldTryTeleportToOwner() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            return this.mob.distanceToSqr((Entity)livingentity) >= (double)(this.teleportDistance * this.teleportDistance);
        }

        private boolean canTeleportTo(BlockPos pPos) {
            Level level = this.mob.level();
            if (!level.isLoaded(pPos)) {
                return false;
            }
            if (!level.getBlockState(pPos).isAir() || !level.getBlockState(pPos.above()).isAir()) {
                return false;
            }
            BlockState blockstate = level.getBlockState(pPos.below());
            if (!blockstate.isSolid() || blockstate.getBlock() instanceof LeavesBlock) {
                return false;
            }
            PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this.mob, (BlockPos)pPos);
            if (pathtype != PathType.WALKABLE) {
                return false;
            }
            BlockPos blockpos = pPos.subtract((Vec3i)this.mob.blockPosition());
            return level.noCollision((Entity)this.mob, this.mob.getBoundingBox().move(blockpos));
        }
    }

    public static class ApplyRandomEffectGoal
    extends Goal {
        private final AbstractSpellCastingPet entity;
        private final Supplier<LivingEntity> targetEntity;
        private final List<MobEffectInstance> effectHolders;
        private final int interval;
        private int tickCounter;

        public ApplyRandomEffectGoal(AbstractSpellCastingPet entity, Supplier<LivingEntity> targetEntity, List<MobEffectInstance> effectHolders, int interval) {
            this.entity = entity;
            this.targetEntity = targetEntity;
            this.effectHolders = effectHolders;
            this.interval = interval;
            this.tickCounter = 0;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            if (!this.entity.canExecuteGoalsInHouse()) {
                return false;
            }
            if (this.horizontalDistanceSqr(owner, this.entity.position()) > 400.0f) {
                return false;
            }
            return ++this.tickCounter >= this.interval;
        }

        private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
            double dx = livingEntity.getX() - vec3.x;
            double dz = livingEntity.getZ() - vec3.z;
            return (float)(dx * dx + dz * dz);
        }

        public void start() {
            this.tickCounter = 0;
            this.entity.triggerAnim("interact_controller", "interact");
            LivingEntity owner = this.targetEntity.get();
            int randomIndex = ThreadLocalRandom.current().nextInt(this.effectHolders.size());
            this.entity.triggerAnim("interact_controller", "interact");
            owner.addEffect(this.effectHolders.get(randomIndex));
        }

        public boolean canContinueToUse() {
            if (!this.entity.canExecuteGoalsInHouse()) {
                return false;
            }
            return this.canUse();
        }
    }

    public static class FindAndUsePetBedGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final double searchRadius;
        private BlockPos targetBedPos;
        private Vec3 exactSleepPosition;
        private int cooldownTicks;
        private static final int SEARCH_COOLDOWN = 60;
        private boolean hasSnappedToBed = false;

        public FindAndUsePetBedGoal(AbstractSpellCastingPet pet, double searchRadius) {
            this.pet = pet;
            this.searchRadius = searchRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.pet.level().isClientSide && this.pet.tickCount % 100 == 0) {
                FamiliarsLib.LOGGER.debug("FindAndUsePetBedGoal check - Pet: " + String.valueOf(this.pet.getUUID()) + ", Sitting: " + this.pet.getIsSitting() + ", Health: " + this.pet.getHealth() + "/" + this.pet.getMaxHealth() + ", Cooldown: " + this.cooldownTicks);
            }
            if (this.pet.getIsSitting().booleanValue()) {
                return false;
            }
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            if (this.pet.getHealth() >= this.pet.getMaxHealth()) {
                this.cooldownTicks = 60;
                return false;
            }
            BlockPos foundBed = this.findLinkedBed();
            if (foundBed != null) {
                this.targetBedPos = foundBed;
                BlockEntity be = this.pet.level().getBlockEntity(this.targetBedPos);
                if (be instanceof AbstractFamiliarBedBlockEntity) {
                    AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)be;
                    this.exactSleepPosition = petBed.getSleepPosition();
                    this.hasSnappedToBed = false;
                    FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.pet.getUUID()) + " found linked bed at " + String.valueOf(this.targetBedPos) + ", exact sleep position: " + String.valueOf(this.exactSleepPosition));
                    return true;
                }
            }
            this.cooldownTicks = 60;
            return false;
        }

        public boolean canContinueToUse() {
            return this.pet.getIsSitting() == false && this.targetBedPos != null && this.exactSleepPosition != null && this.isValidLinkedBed(this.targetBedPos);
        }

        public void start() {
            if (this.exactSleepPosition != null) {
                FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.pet.getUUID()) + " starting to move to exact sleep position: " + String.valueOf(this.exactSleepPosition));
                this.pet.getNavigation().moveTo(this.exactSleepPosition.x, this.exactSleepPosition.y, this.exactSleepPosition.z, 1.0);
            }
            this.hasSnappedToBed = false;
        }

        public void tick() {
            if (this.targetBedPos == null || this.exactSleepPosition == null) {
                return;
            }
            Vec3 petPos = this.pet.position();
            double distanceToSleepPos = petPos.distanceTo(this.exactSleepPosition);
            if (distanceToSleepPos <= 1.5 && !this.hasSnappedToBed) {
                if (!this.pet.level().isClientSide) {
                    FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.pet.getUUID()) + " within snap range, teleporting to exact position");
                    this.pet.getNavigation().stop();
                    this.pet.setDeltaMovement(Vec3.ZERO);
                    FamiliarBedHelper.snapToExactBedPosition(this.pet);
                    this.hasSnappedToBed = true;
                    try {
                        this.pet.setSitting(true);
                    }
                    catch (Exception e) {
                        FamiliarsLib.LOGGER.error("Error setting pet to sitting: ", (Throwable)e);
                    }
                }
                return;
            }
            if (this.hasSnappedToBed && distanceToSleepPos <= 0.5) {
                if (!this.pet.level().isClientSide && !this.pet.getIsSitting().booleanValue()) {
                    try {
                        this.pet.setSitting(true);
                    }
                    catch (Exception e) {
                        FamiliarsLib.LOGGER.error("Error setting pet to sitting after snap: ", (Throwable)e);
                    }
                }
                return;
            }
            if (!this.hasSnappedToBed && (this.pet.getNavigation().isDone() || distanceToSleepPos > 3.0)) {
                this.pet.getNavigation().moveTo(this.exactSleepPosition.x, this.exactSleepPosition.y, this.exactSleepPosition.z, 1.2);
            }
        }

        public void stop() {
            this.targetBedPos = null;
            this.exactSleepPosition = null;
            this.hasSnappedToBed = false;
            this.pet.getNavigation().stop();
            this.cooldownTicks = 60;
        }

        private BlockPos findLinkedBed() {
            if (this.pet.getSummoner() == null) {
                return null;
            }
            BlockPos petPos = this.pet.blockPosition();
            UUID petUUID = this.pet.getUUID();
            FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(petUUID) + " searching for linked bed around " + String.valueOf(petPos));
            LivingEntity livingEntity = this.pet.getSummoner();
            if (!(livingEntity instanceof ServerPlayer)) {
                return null;
            }
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            BedLinkData linkData = (BedLinkData)serverPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
            BlockPos linkedBedPos = linkData.getLinkedBed(petUUID);
            if (linkedBedPos == null) {
                FamiliarsLib.LOGGER.debug("No linked bed found for pet " + String.valueOf(petUUID));
                return null;
            }
            double distance = petPos.distSqr((Vec3i)linkedBedPos);
            if (distance > this.searchRadius * this.searchRadius) {
                FamiliarsLib.LOGGER.debug("Linked bed at " + String.valueOf(linkedBedPos) + " is too far (distance: " + Math.sqrt(distance) + ")");
                return null;
            }
            if (this.isValidLinkedBed(linkedBedPos)) {
                FamiliarsLib.LOGGER.debug("Found valid linked bed at " + String.valueOf(linkedBedPos));
                return linkedBedPos;
            }
            FamiliarsLib.LOGGER.debug("Linked bed at " + String.valueOf(linkedBedPos) + " is no longer valid");
            linkData.unlinkBed(linkedBedPos);
            return null;
        }

        private boolean isValidLinkedBed(BlockPos pos) {
            try {
                if (!(this.pet.level().getBlockState(pos).getBlock() instanceof AbstractFamiliarBedBlock)) {
                    return false;
                }
                BlockEntity be = this.pet.level().getBlockEntity(pos);
                if (!(be instanceof AbstractFamiliarBedBlockEntity)) {
                    return false;
                }
                AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)be;
                return petBed.isLinkedToPet(this.pet.getUUID());
            }
            catch (Exception e) {
                FamiliarsLib.LOGGER.error("Error checking if bed is valid: ", (Throwable)e);
                return false;
            }
        }
    }
}

