/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarStorageBlockEntity;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FamiliarDeathStorageHandler {
    public static void notifyFamiliarDeath(AbstractSpellCastingPet familiar) {
        BlockEntity blockEntity;
        if (familiar.level().isClientSide) {
            return;
        }
        UUID familiarId = familiar.getUUID();
        ServerLevel level = (ServerLevel)familiar.level();
        FamiliarsLib.LOGGER.debug("Notifying storage blocks about death of familiar {}", (Object)familiarId);
        if (familiar.getIsInHouse().booleanValue() && familiar.housePosition != null && (blockEntity = level.getBlockEntity(familiar.housePosition)) instanceof AbstractFamiliarStorageBlockEntity) {
            AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
            storageEntity.handleFamiliarDeath(familiarId);
            FamiliarsLib.LOGGER.debug("Notified house at {} about familiar death", (Object)familiar.housePosition);
        }
    }
}

