/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.AbstractFamiliarBedBlock;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarBedBlockEntity;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FamiliarBedHelper {
    public static void snapToExactBedPosition(AbstractSpellCastingPet familiar) {
        AbstractFamiliarBedBlockEntity petBed;
        BlockEntity be;
        double distanceToBed;
        ServerPlayer serverPlayer;
        BedLinkData linkData;
        BlockPos linkedBedPos;
        LivingEntity livingEntity = familiar.getSummoner();
        if (livingEntity instanceof ServerPlayer && (linkedBedPos = (linkData = (BedLinkData)(serverPlayer = (ServerPlayer)livingEntity).getData(AttachmentRegistry.BED_LINK_DATA)).getLinkedBed(familiar.getUUID())) != null && (distanceToBed = familiar.blockPosition().distSqr((Vec3i)linkedBedPos)) <= 9.0 && familiar.level().getBlockState(linkedBedPos).getBlock() instanceof AbstractFamiliarBedBlock && (be = familiar.level().getBlockEntity(linkedBedPos)) instanceof AbstractFamiliarBedBlockEntity && (petBed = (AbstractFamiliarBedBlockEntity)be).isLinkedToPet(familiar.getUUID())) {
            Vec3 exactPos = petBed.getSleepPosition();
            double distance = familiar.position().distanceTo(exactPos);
            if (distance <= 3.0) {
                familiar.setPos(exactPos.x, exactPos.y, exactPos.z);
                if (!familiar.level().isClientSide) {
                    FamiliarsLib.LOGGER.debug("Snapped pet " + String.valueOf(familiar.getUUID()) + " to linked bed position: " + String.valueOf(exactPos));
                }
            }
        }
    }

    public static boolean isOnCompatibleBed(AbstractSpellCastingPet familiar) {
        BlockPos petPos = familiar.blockPosition();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 0; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockEntity be;
                    BlockPos checkPos = petPos.offset(x, y, z);
                    if (!(familiar.level().getBlockState(checkPos).getBlock() instanceof AbstractFamiliarBedBlock) || !((be = familiar.level().getBlockEntity(checkPos)) instanceof AbstractFamiliarBedBlockEntity)) continue;
                    AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)be;
                    boolean inCorrectPosition = petBed.isPositionCorrectForSleeping(familiar.position());
                    if (!petBed.isLinkedToPet(familiar.getUUID())) continue;
                    return inCorrectPosition;
                }
            }
        }
        return false;
    }
}

