/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.util.familiars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.registry.AttributeRegistry;
import net.alshanex.familiarslib.util.CurioUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class FamiliarAttributesHelper {
    private static final ResourceLocation SHARED_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_spell_power");
    private static final ResourceLocation SHARED_SPELL_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_spell_resist");
    private static final ResourceLocation SHARED_FIRE_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_fire_spell_power");
    private static final ResourceLocation SHARED_ICE_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_ice_spell_power");
    private static final ResourceLocation SHARED_LIGHTNING_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_lightning_spell_power");
    private static final ResourceLocation SHARED_HOLY_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_holy_spell_power");
    private static final ResourceLocation SHARED_ENDER_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_ender_spell_power");
    private static final ResourceLocation SHARED_BLOOD_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_blood_spell_power");
    private static final ResourceLocation SHARED_EVOCATION_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_evocation_spell_power");
    private static final ResourceLocation SHARED_NATURE_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_nature_spell_power");
    private static final ResourceLocation SHARED_ELDRITCH_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_eldritch_spell_power");
    private static final ResourceLocation SHARED_SOUND_SPELL_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_sound_spell_power");
    private static final ResourceLocation SHARED_FIRE_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_fire_magic_resist");
    private static final ResourceLocation SHARED_ICE_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_ice_magic_resist");
    private static final ResourceLocation SHARED_LIGHTNING_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_lightning_magic_resist");
    private static final ResourceLocation SHARED_HOLY_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_holy_magic_resist");
    private static final ResourceLocation SHARED_ENDER_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_ender_magic_resist");
    private static final ResourceLocation SHARED_BLOOD_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_blood_magic_resist");
    private static final ResourceLocation SHARED_EVOCATION_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_evocation_magic_resist");
    private static final ResourceLocation SHARED_NATURE_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_nature_magic_resist");
    private static final ResourceLocation SHARED_ELDRITCH_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_eldritch_magic_resist");
    private static final ResourceLocation SHARED_SOUND_MAGIC_RESIST_ID = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"shared_sound_magic_resist");
    private static final Map<Holder<Attribute>, ResourceLocation> SHARED_ATTRIBUTES = FamiliarAttributesHelper.createSharedAttributesMap();

    private static Map<Holder<Attribute>, ResourceLocation> createSharedAttributesMap() {
        HashMap<Holder<Attribute>, ResourceLocation> map = new HashMap<Holder<Attribute>, ResourceLocation>();
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.SPELL_POWER, SHARED_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.SPELL_RESIST, SHARED_SPELL_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.FIRE_SPELL_POWER, SHARED_FIRE_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ICE_SPELL_POWER, SHARED_ICE_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.LIGHTNING_SPELL_POWER, SHARED_LIGHTNING_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.HOLY_SPELL_POWER, SHARED_HOLY_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ENDER_SPELL_POWER, SHARED_ENDER_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.BLOOD_SPELL_POWER, SHARED_BLOOD_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.EVOCATION_SPELL_POWER, SHARED_EVOCATION_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.NATURE_SPELL_POWER, SHARED_NATURE_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ELDRITCH_SPELL_POWER, SHARED_ELDRITCH_SPELL_POWER_ID);
        map.put((Holder<Attribute>)AttributeRegistry.SOUND_SPELL_POWER, SHARED_SOUND_SPELL_POWER_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.FIRE_MAGIC_RESIST, SHARED_FIRE_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ICE_MAGIC_RESIST, SHARED_ICE_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.LIGHTNING_MAGIC_RESIST, SHARED_LIGHTNING_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.HOLY_MAGIC_RESIST, SHARED_HOLY_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ENDER_MAGIC_RESIST, SHARED_ENDER_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.BLOOD_MAGIC_RESIST, SHARED_BLOOD_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.EVOCATION_MAGIC_RESIST, SHARED_EVOCATION_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.NATURE_MAGIC_RESIST, SHARED_NATURE_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)io.redspace.ironsspellbooks.api.registry.AttributeRegistry.ELDRITCH_MAGIC_RESIST, SHARED_ELDRITCH_MAGIC_RESIST_ID);
        map.put((Holder<Attribute>)AttributeRegistry.SOUND_MAGIC_RESIST, SHARED_SOUND_MAGIC_RESIST_ID);
        return map;
    }

    public static void applyAttributes(AbstractSpellCastingPet familiar) {
        LivingEntity owner = familiar.getSummoner();
        if (!(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)owner;
        if (!CurioUtils.isWearingFamiliarSpellbook((LivingEntity)serverPlayer)) {
            FamiliarAttributesHelper.removeAttributes(familiar);
            return;
        }
        List<AbstractSpellCastingPet> summonedFamiliars = FamiliarAttributesHelper.getSummonedFamiliars(serverPlayer);
        if (summonedFamiliars.isEmpty()) {
            return;
        }
        FamiliarAttributesHelper.applySharedAttributeModifiers(familiar, serverPlayer, summonedFamiliars.size());
    }

    public static void removeAttributes(AbstractSpellCastingPet familiar) {
        for (Map.Entry<Holder<Attribute>, ResourceLocation> entry : SHARED_ATTRIBUTES.entrySet()) {
            AttributeInstance attributeInstance = familiar.getAttribute(entry.getKey());
            if (attributeInstance == null) continue;
            attributeInstance.removeModifier(entry.getValue());
        }
    }

    public static void recalculateAllFamiliarAttributes(ServerPlayer player) {
        if (!CurioUtils.isWearingFamiliarSpellbook((LivingEntity)player)) {
            FamiliarAttributesHelper.removeAllFamiliarAttributes(player);
            return;
        }
        List<AbstractSpellCastingPet> summonedFamiliars = FamiliarAttributesHelper.getSummonedFamiliars(player);
        if (summonedFamiliars.isEmpty()) {
            return;
        }
        for (AbstractSpellCastingPet familiar : summonedFamiliars) {
            FamiliarAttributesHelper.applySharedAttributeModifiers(familiar, player, summonedFamiliars.size());
        }
    }

    public static void removeAllFamiliarAttributes(ServerPlayer player) {
        List<AbstractSpellCastingPet> summonedFamiliars = FamiliarAttributesHelper.getSummonedFamiliars(player);
        for (AbstractSpellCastingPet familiar : summonedFamiliars) {
            FamiliarAttributesHelper.removeAttributes(familiar);
        }
    }

    private static void applySharedAttributeModifiers(AbstractSpellCastingPet familiar, ServerPlayer player, int totalFamiliars) {
        for (Map.Entry<Holder<Attribute>, ResourceLocation> entry : SHARED_ATTRIBUTES.entrySet()) {
            double baseValue;
            double playerValue;
            double additionalValue;
            Holder<Attribute> attributeHolder = entry.getKey();
            ResourceLocation modifierLocation = entry.getValue();
            AttributeInstance playerAttribute = player.getAttribute(attributeHolder);
            if (playerAttribute == null || (additionalValue = (playerValue = playerAttribute.getValue()) - (baseValue = playerAttribute.getBaseValue())) <= 0.0) continue;
            double familiarShare = additionalValue / (double)totalFamiliars;
            AttributeInstance familiarAttribute = familiar.getAttribute(attributeHolder);
            if (familiarAttribute == null) continue;
            familiarAttribute.removeModifier(modifierLocation);
            AttributeModifier modifier = new AttributeModifier(modifierLocation, familiarShare, AttributeModifier.Operation.ADD_VALUE);
            familiarAttribute.addTransientModifier(modifier);
        }
    }

    private static List<AbstractSpellCastingPet> getSummonedFamiliars(ServerPlayer player) {
        ArrayList<AbstractSpellCastingPet> summonedFamiliars = new ArrayList<AbstractSpellCastingPet>();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return summonedFamiliars;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        for (Entity entity : serverLevel.getAllEntities()) {
            AbstractSpellCastingPet familiar;
            UUID ownerUUID;
            if (!(entity instanceof AbstractSpellCastingPet) || (ownerUUID = (familiar = (AbstractSpellCastingPet)entity).getOwnerUUID()) == null || !ownerUUID.equals(player.getUUID()) || !familiarData.hasFamiliar(familiar.getUUID()) || familiar.getIsInHouse().booleanValue()) continue;
            summonedFamiliars.add(familiar);
        }
        return summonedFamiliars;
    }

    public static void handleSpellbookEquipChange(ServerPlayer player, boolean equipped) {
        if (equipped) {
            FamiliarAttributesHelper.recalculateAllFamiliarAttributes(player);
        } else {
            FamiliarAttributesHelper.removeAllFamiliarAttributes(player);
        }
    }

    public static void handleFamiliarSummoned(ServerPlayer player, AbstractSpellCastingPet familiar) {
        if (CurioUtils.isWearingFamiliarSpellbook((LivingEntity)player)) {
            FamiliarAttributesHelper.recalculateAllFamiliarAttributes(player);
        }
    }

    public static void handleFamiliarDismissed(ServerPlayer player, AbstractSpellCastingPet familiar) {
        FamiliarAttributesHelper.removeAttributes(familiar);
        if (CurioUtils.isWearingFamiliarSpellbook((LivingEntity)player)) {
            FamiliarAttributesHelper.recalculateAllFamiliarAttributes(player);
        }
    }

    public static void handlePlayerAttributeChange(ServerPlayer player) {
        if (CurioUtils.isWearingFamiliarSpellbook((LivingEntity)player)) {
            FamiliarAttributesHelper.recalculateAllFamiliarAttributes(player);
        }
    }

    public static void debugFamiliarAttributes(AbstractSpellCastingPet familiar) {
        FamiliarsLib.LOGGER.debug("Familiar {} attributes:", (Object)familiar.getUUID());
        for (Holder<Attribute> attributeHolder : SHARED_ATTRIBUTES.keySet()) {
            AttributeInstance instance = familiar.getAttribute(attributeHolder);
            if (instance == null) continue;
            FamiliarsLib.LOGGER.debug("  {}: {} (base: {})", new Object[]{((Attribute)attributeHolder.value()).getDescriptionId(), instance.getValue(), instance.getBaseValue()});
        }
    }

    public static void applyHealthAttribute(AbstractSpellCastingPet pet) {
        int level = pet.getHealthStacks();
        ResourceLocation healthModifierId = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"familiar_health_modifier");
        AttributeInstance health = pet.getAttribute(Attributes.MAX_HEALTH);
        if (health != null) {
            health.removeModifier(healthModifierId);
            if (level > 0) {
                double totalHealthBonus = (double)level * 0.1;
                AttributeModifier healthModifier = new AttributeModifier(healthModifierId, totalHealthBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
                health.addPermanentModifier(healthModifier);
                FamiliarsLib.LOGGER.debug("Applied health attribute to pet {}: {} stacks, modifier: {}%, new max health: {}", new Object[]{pet.getUUID(), level, totalHealthBonus * 100.0, health.getValue()});
            }
            if ((double)pet.getHealth() > health.getValue()) {
                pet.setHealth((float)health.getValue());
            }
        }
    }

    public static void applyArmorAttribute(AbstractSpellCastingPet pet) {
        int level = pet.getArmorStacks();
        ResourceLocation armorModifierId = ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"familiar_armor_modifier");
        AttributeInstance armor = pet.getAttribute(Attributes.ARMOR);
        if (armor != null) {
            armor.removeModifier(armorModifierId);
            if (level > 0) {
                double totalArmorBonus = (double)level * 1.0;
                AttributeModifier armorModifier = new AttributeModifier(armorModifierId, totalArmorBonus, AttributeModifier.Operation.ADD_VALUE);
                armor.addPermanentModifier(armorModifier);
                FamiliarsLib.LOGGER.debug("Applied armor attribute to pet {}: {} stacks, new armor: {}", new Object[]{pet.getUUID(), level, armor.getValue()});
            }
        }
    }

    public static void applyAllConsumableAttributes(AbstractSpellCastingPet pet) {
        FamiliarAttributesHelper.applyHealthAttribute(pet);
        FamiliarAttributesHelper.applyArmorAttribute(pet);
        FamiliarsLib.LOGGER.debug("Applied all consumable attributes to pet {}: {} health stacks, {} armor stacks", new Object[]{pet.getUUID(), pet.getHealthStacks(), pet.getArmorStacks()});
    }
}

