/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.network.LinkFamiliarToBedPacket;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BedLinkSelectionScreen
extends Screen {
    private static final int PANEL_WIDTH = 200;
    private static final int PANEL_HEIGHT = 300;
    private static final int FAMILIAR_ITEM_HEIGHT = 80;
    private static final int SCROLL_SPEED = 20;
    private final BlockPos bedPos;
    private final List<FamiliarEntry> familiarEntries = new ArrayList<FamiliarEntry>();
    private UUID selectedFamiliarId;
    private UUID currentLinkedFamiliarId;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private float animationTime = 0.0f;
    private int leftPanelX;
    private int rightPanelX;
    private int panelY;
    private int buttonY;
    private int linkButtonX;
    private int unlinkButtonX;
    private int buttonWidth;
    private int buttonHeight;
    private static final ResourceLocation HEART_CONTAINER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/container.png");
    private static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png");

    public BedLinkSelectionScreen(BlockPos bedPos) {
        super((Component)Component.translatable((String)"ui.familiarslib.familiar_bed_screen"));
        this.bedPos = bedPos;
    }

    protected void init() {
        super.init();
        this.loadFamiliarData();
        this.leftPanelX = (this.width - 400 - 20) / 2;
        this.rightPanelX = this.leftPanelX + 200 + 20;
        this.panelY = (this.height - 300) / 2 + 30;
    }

    private void loadFamiliarData() {
        this.familiarEntries.clear();
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        BedLinkData linkData = (BedLinkData)this.minecraft.player.getData(AttachmentRegistry.BED_LINK_DATA);
        this.selectedFamiliarId = this.currentLinkedFamiliarId = linkData.getLinkedFamiliar(this.bedPos);
        Map<UUID, CompoundTag> familiars = familiarData.getAllFamiliars();
        for (Map.Entry<UUID, CompoundTag> entry : familiars.entrySet()) {
            Entity entity;
            UUID id = entry.getKey();
            CompoundTag nbt = entry.getValue();
            String entityTypeString = nbt.getString("id");
            EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
            if (entityType == null || !((entity = entityType.create((Level)this.minecraft.level)) instanceof AbstractSpellCastingPet)) continue;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            familiar.load(nbt);
            familiar.setUUID(id);
            String displayName = familiar.hasCustomName() ? familiar.getCustomName().getString() : familiar.getType().getDescription().getString();
            float health = nbt.getFloat("currentHealth");
            BlockPos linkedBed = linkData.getLinkedBed(id);
            boolean isLinkedToOtherBed = linkedBed != null && !linkedBed.equals((Object)this.bedPos);
            this.familiarEntries.add(new FamiliarEntry(id, familiar, displayName, health, isLinkedToOtherBed));
        }
        int visibleItems = 3;
        this.maxScroll = Math.max(0, (this.familiarEntries.size() - visibleItems) * 80);
    }

    public void reloadFamiliarData() {
        try {
            boolean foundSelected;
            FamiliarsLib.LOGGER.debug("=== BedLinkSelectionScreen.reloadFamiliarData() START ===");
            UUID previousSelected = this.selectedFamiliarId;
            UUID previousLinked = this.currentLinkedFamiliarId;
            int previousCount = this.familiarEntries.size();
            FamiliarsLib.LOGGER.debug("Previous state - Count: {}, Selected: {}, Linked: {}", new Object[]{previousCount, previousSelected, previousLinked});
            this.familiarEntries.clear();
            if (this.minecraft == null || this.minecraft.player == null) {
                FamiliarsLib.LOGGER.debug("Minecraft or player is null, cannot reload familiar data");
                return;
            }
            PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            BedLinkData linkData = (BedLinkData)this.minecraft.player.getData(AttachmentRegistry.BED_LINK_DATA);
            if (familiarData == null || linkData == null) {
                FamiliarsLib.LOGGER.debug("FamiliarData or BedLinkData is null");
                return;
            }
            this.selectedFamiliarId = this.currentLinkedFamiliarId = linkData.getLinkedFamiliar(this.bedPos);
            FamiliarsLib.LOGGER.debug("Current linked familiar for bed {}: {}", (Object)this.bedPos, (Object)this.currentLinkedFamiliarId);
            Map<UUID, CompoundTag> familiars = familiarData.getAllFamiliars();
            FamiliarsLib.LOGGER.debug("Total familiars available: {}", (Object)familiars.size());
            if (familiars.isEmpty()) {
                FamiliarsLib.LOGGER.debug("No familiars found, closing screen");
                this.onClose();
                return;
            }
            for (Map.Entry<UUID, CompoundTag> entry2 : familiars.entrySet()) {
                UUID id = entry2.getKey();
                CompoundTag nbt = entry2.getValue();
                FamiliarsLib.LOGGER.debug("Processing familiar: {} with health: {}", (Object)id, (Object)Float.valueOf(nbt.getFloat("currentHealth")));
                String entityTypeString = nbt.getString("id");
                EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
                if (entityType != null) {
                    Entity entity = entityType.create((Level)this.minecraft.level);
                    if (!(entity instanceof AbstractSpellCastingPet)) continue;
                    AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
                    familiar.load(nbt);
                    familiar.setUUID(id);
                    String displayName = familiar.hasCustomName() ? familiar.getCustomName().getString() : familiar.getType().getDescription().getString();
                    float health = nbt.getFloat("currentHealth");
                    BlockPos linkedBed = linkData.getLinkedBed(id);
                    boolean isLinkedToOtherBed = linkedBed != null && !linkedBed.equals((Object)this.bedPos);
                    this.familiarEntries.add(new FamiliarEntry(id, familiar, displayName, health, isLinkedToOtherBed));
                    FamiliarsLib.LOGGER.debug("Added familiar entry: {} ({}) - linked to other bed: {}", new Object[]{displayName, id, isLinkedToOtherBed});
                    continue;
                }
                FamiliarsLib.LOGGER.debug("Unknown entity type for familiar {}: {}", (Object)id, (Object)entityTypeString);
            }
            if (this.selectedFamiliarId == null && !this.familiarEntries.isEmpty()) {
                this.selectedFamiliarId = this.familiarEntries.get((int)0).id;
                FamiliarsLib.LOGGER.debug("No familiar selected, defaulting to first: {}", (Object)this.selectedFamiliarId);
            }
            if (this.selectedFamiliarId != null && !(foundSelected = this.familiarEntries.stream().anyMatch(entry -> entry.id.equals(this.selectedFamiliarId)))) {
                FamiliarsLib.LOGGER.debug("Selected familiar {} not found in entries, selecting first available", (Object)this.selectedFamiliarId);
                this.selectedFamiliarId = !this.familiarEntries.isEmpty() ? this.familiarEntries.get((int)0).id : null;
            }
            int visibleItems = 3;
            this.maxScroll = Math.max(0, (this.familiarEntries.size() - visibleItems) * 80);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            FamiliarsLib.LOGGER.debug("Reload completed - New count: {}, New selected: {}, New linked: {}, Max scroll: {}", new Object[]{this.familiarEntries.size(), this.selectedFamiliarId, this.currentLinkedFamiliarId, this.maxScroll});
            FamiliarsLib.LOGGER.debug("=== BedLinkSelectionScreen.reloadFamiliarData() END ===");
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error reloading familiar data in BedLinkSelectionScreen: ", (Throwable)e);
            try {
                this.onClose();
            }
            catch (Exception closeError) {
                FamiliarsLib.LOGGER.error("Error closing screen after reload failure: ", (Throwable)closeError);
            }
        }
    }

    private void drawHeartIcon(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(HEART_CONTAINER, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.blit(HEART_FULL, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.animationTime += partialTick;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        MutableComponent titleComponent = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip1");
        int titleWidth = this.font.width((FormattedText)titleComponent);
        guiGraphics.drawString(this.font, (Component)titleComponent, (this.width - titleWidth) / 2, this.panelY - 40, 0xFFFFFF);
        if (this.currentLinkedFamiliarId != null) {
            FamiliarEntry currentLinked = this.getFamiliarEntry(this.currentLinkedFamiliarId);
            if (currentLinked != null) {
                MutableComponent statusComponent = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip2", (Object[])new Object[]{currentLinked.displayName});
                int statusWidth = this.font.width((FormattedText)statusComponent);
                guiGraphics.drawString(this.font, (Component)statusComponent, (this.width - statusWidth) / 2, this.panelY - 20, 0x55FF55);
            }
        } else {
            MutableComponent statusComponent = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip3");
            int statusWidth = this.font.width((FormattedText)statusComponent);
            guiGraphics.drawString(this.font, (Component)statusComponent, (this.width - statusWidth) / 2, this.panelY - 20, 0xFFFF55);
        }
        this.renderSelectedFamiliar(guiGraphics, mouseX, mouseY, partialTick);
        this.renderFamiliarList(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderSelectedFamiliar(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        FamiliarEntry selectedEntry = this.getFamiliarEntry(this.selectedFamiliarId);
        if (selectedEntry == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(this.leftPanelX + 100), (float)(this.panelY + 100), 100.0f);
        poseStack.scale(60.0f, 60.0f, 60.0f);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(45.0));
        poseStack.mulPose(rotation);
        this.renderEntity(guiGraphics, (LivingEntity)selectedEntry.familiar, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        int infoY = this.panelY + 120;
        MutableComponent nameComponent = Component.literal((String)selectedEntry.displayName);
        int nameWidth = this.font.width((FormattedText)nameComponent);
        guiGraphics.drawString(this.font, (Component)nameComponent, this.leftPanelX + (200 - nameWidth) / 2, infoY, 0xFFFFFF);
        MutableComponent healthComponent = Component.literal((String)String.format("%.1f", Float.valueOf(selectedEntry.health)));
        int healthWidth = this.font.width((FormattedText)healthComponent);
        this.drawHeartIcon(guiGraphics, this.leftPanelX + (200 - healthWidth) / 2 - 12, infoY += 20);
        guiGraphics.drawString(this.font, (Component)healthComponent, this.leftPanelX + (200 - healthWidth) / 2, infoY, 0xFF5555);
        if (selectedEntry.isLinkedToOtherBed) {
            MutableComponent warningComponent = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip4");
            int warningWidth = this.font.width((FormattedText)warningComponent);
            guiGraphics.drawString(this.font, (Component)warningComponent, this.leftPanelX + (200 - warningWidth) / 2, infoY += 20, 0xFFAA00);
        }
        this.renderButtons(guiGraphics, mouseX, mouseY, partialTick, infoY + 20);
    }

    private void renderFamiliarList(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int scissorX = this.rightPanelX;
        int scissorY = this.panelY;
        int scissorWidth = 200;
        int scissorHeight = 300;
        this.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
        int currentY = this.panelY - this.scrollOffset;
        for (int i = 0; i < this.familiarEntries.size(); ++i) {
            FamiliarEntry entry = this.familiarEntries.get(i);
            if (currentY + 80 > this.panelY && currentY < this.panelY + scissorHeight) {
                this.renderFamiliarItem(guiGraphics, entry, this.rightPanelX, currentY, mouseX, mouseY, partialTick);
            }
            currentY += 80;
        }
        this.disableScissor();
    }

    private void renderFamiliarItem(GuiGraphics guiGraphics, FamiliarEntry entry, int x, int y, int mouseX, int mouseY, float partialTick) {
        boolean isHovered;
        PoseStack poseStack = guiGraphics.pose();
        boolean isSelected = entry.id.equals(this.selectedFamiliarId);
        boolean isCurrentlyLinked = entry.id.equals(this.currentLinkedFamiliarId);
        boolean bl = isHovered = mouseX >= x && mouseX < x + 200 && mouseY >= y && mouseY < y + 80;
        if (isCurrentlyLinked) {
            guiGraphics.fill(x, y, x + 200, y + 80, 0x4400AA00);
        } else if (isSelected) {
            guiGraphics.fill(x, y, x + 200, y + 80, 0x4400FF00);
        } else if (isHovered) {
            guiGraphics.fill(x, y, x + 200, y + 80, 0x44FFFFFF);
        }
        poseStack.pushPose();
        poseStack.translate((float)(x + 40), (float)(y + 50), 50.0f);
        poseStack.scale(30.0f, 30.0f, 30.0f);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(45.0));
        poseStack.mulPose(rotation);
        this.renderEntity(guiGraphics, (LivingEntity)entry.familiar, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        MutableComponent nameComponent = Component.literal((String)entry.displayName);
        guiGraphics.drawString(this.font, (Component)nameComponent, x + 85, y + 20, 0xFFFFFF);
        MutableComponent healthComponent = Component.literal((String)String.format("%.0f", Float.valueOf(entry.health)));
        this.drawHeartIcon(guiGraphics, x + 85, y + 35);
        guiGraphics.drawString(this.font, (Component)healthComponent, x + 97, y + 35, 0xFF5555);
        if (entry.isLinkedToOtherBed) {
            MutableComponent warningComponent = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip5");
            guiGraphics.drawString(this.font, (Component)warningComponent, x + 85, y + 50, 0xFFAA00);
        }
        if (isCurrentlyLinked) {
            MutableComponent linkedIndicator = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.tooltip6");
            guiGraphics.drawString(this.font, (Component)linkedIndicator, x + 200 - 60, y + 10, 65280);
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int buttonY) {
        boolean unlinkHovered;
        boolean linkHovered;
        int startX;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int linkButtonX = startX = this.leftPanelX + (200 - totalButtonWidth) / 2;
        boolean canLink = this.selectedFamiliarId != null && !this.selectedFamiliarId.equals(this.currentLinkedFamiliarId);
        int linkButtonColor = canLink ? -16751104 : -13421773;
        boolean bl = linkHovered = mouseX >= linkButtonX && mouseX < linkButtonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
        if (linkHovered && canLink) {
            linkButtonColor = -16742400;
        }
        guiGraphics.fill(linkButtonX, buttonY, linkButtonX + buttonWidth, buttonY + buttonHeight, linkButtonColor);
        guiGraphics.fill(linkButtonX, buttonY, linkButtonX + buttonWidth, buttonY + 1, -1);
        guiGraphics.fill(linkButtonX, buttonY, linkButtonX + 1, buttonY + buttonHeight, -1);
        guiGraphics.fill(linkButtonX + buttonWidth - 1, buttonY, linkButtonX + buttonWidth, buttonY + buttonHeight, -16777216);
        guiGraphics.fill(linkButtonX, buttonY + buttonHeight - 1, linkButtonX + buttonWidth, buttonY + buttonHeight, -16777216);
        MutableComponent linkText = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.link");
        int linkTextWidth = this.font.width((FormattedText)linkText);
        int linkTextColor = canLink ? 0xFFFFFF : 0x666666;
        guiGraphics.drawString(this.font, (Component)linkText, linkButtonX + (buttonWidth - linkTextWidth) / 2, buttonY + 6, linkTextColor);
        int unlinkButtonX = startX + buttonWidth + buttonSpacing;
        boolean canUnlink = this.currentLinkedFamiliarId != null;
        int unlinkButtonColor = canUnlink ? -10092544 : -13421773;
        boolean bl2 = unlinkHovered = mouseX >= unlinkButtonX && mouseX < unlinkButtonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
        if (unlinkHovered && canUnlink) {
            unlinkButtonColor = -7864320;
        }
        guiGraphics.fill(unlinkButtonX, buttonY, unlinkButtonX + buttonWidth, buttonY + buttonHeight, unlinkButtonColor);
        guiGraphics.fill(unlinkButtonX, buttonY, unlinkButtonX + buttonWidth, buttonY + 1, -1);
        guiGraphics.fill(unlinkButtonX, buttonY, unlinkButtonX + 1, buttonY + buttonHeight, -1);
        guiGraphics.fill(unlinkButtonX + buttonWidth - 1, buttonY, unlinkButtonX + buttonWidth, buttonY + buttonHeight, -16777216);
        guiGraphics.fill(unlinkButtonX, buttonY + buttonHeight - 1, unlinkButtonX + buttonWidth, buttonY + buttonHeight, -16777216);
        MutableComponent unlinkText = Component.translatable((String)"ui.familiarslib.familiar_bed_screen.unlink");
        int unlinkTextWidth = this.font.width((FormattedText)unlinkText);
        int unlinkTextColor = canUnlink ? 0xFFFFFF : 0x666666;
        guiGraphics.drawString(this.font, (Component)unlinkText, unlinkButtonX + (buttonWidth - unlinkTextWidth) / 2, buttonY + 6, unlinkTextColor);
        this.buttonY = buttonY;
        this.linkButtonX = linkButtonX;
        this.unlinkButtonX = unlinkButtonX;
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
    }

    private void renderEntity(GuiGraphics guiGraphics, LivingEntity entity, float x, float y, float z) {
        if (entity == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        float rotationY = this.animationTime * 0.02f % ((float)Math.PI * 2);
        Quaternionf rotation = new Quaternionf().rotateY(rotationY);
        poseStack.mulPose(rotation);
        Quaternionf tiltRotation = new Quaternionf().rotateX((float)Math.toRadians(-10.0));
        poseStack.mulPose(tiltRotation);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.2f, 1.0f, -1.0f), (Vector3f)new Vector3f(-0.2f, -1.0f, 0.0f));
        RenderSystem.disableCull();
        try {
            MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
            entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            guiGraphics.flush();
        }
        catch (Exception e) {
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            MutableComponent errorText = Component.literal((String)"Error");
            int textWidth = this.font.width((FormattedText)errorText);
            guiGraphics.drawString(this.font, (Component)errorText, (int)x - textWidth / 2, (int)y, 0xFF5555);
        }
        RenderSystem.enableCull();
        poseStack.popPose();
    }

    private FamiliarEntry getFamiliarEntry(UUID familiarId) {
        if (familiarId == null) {
            return null;
        }
        return this.familiarEntries.stream().filter(entry -> entry.id.equals(familiarId)).findFirst().orElse(null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int relativeY;
            int itemIndex;
            if (mouseX >= (double)this.rightPanelX && mouseX < (double)(this.rightPanelX + 200) && mouseY >= (double)this.panelY && mouseY < (double)(this.panelY + 300) && (itemIndex = (relativeY = (int)(mouseY - (double)this.panelY + (double)this.scrollOffset)) / 80) >= 0 && itemIndex < this.familiarEntries.size()) {
                FamiliarEntry selected = this.familiarEntries.get(itemIndex);
                this.selectedFamiliarId = selected.id;
                return true;
            }
            if (this.buttonY > 0) {
                if (mouseX >= (double)this.linkButtonX && mouseX < (double)(this.linkButtonX + this.buttonWidth) && mouseY >= (double)this.buttonY && mouseY < (double)(this.buttonY + this.buttonHeight)) {
                    if (this.selectedFamiliarId != null && !this.selectedFamiliarId.equals(this.currentLinkedFamiliarId)) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new LinkFamiliarToBedPacket(this.bedPos, this.selectedFamiliarId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.onClose();
                    }
                    return true;
                }
                if (mouseX >= (double)this.unlinkButtonX && mouseX < (double)(this.unlinkButtonX + this.buttonWidth) && mouseY >= (double)this.buttonY && mouseY < (double)(this.buttonY + this.buttonHeight)) {
                    if (this.currentLinkedFamiliarId != null) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new LinkFamiliarToBedPacket(this.bedPos, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.onClose();
                    }
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)this.rightPanelX && mouseX < (double)(this.rightPanelX + 200) && mouseY >= (double)this.panelY && mouseY < (double)(this.panelY + 300)) {
            this.scrollOffset -= (int)(scrollY * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -2013265920);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void enableScissor(int x1, int y1, int x2, int y2) {
        double scale = this.minecraft.getWindow().getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)this.minecraft.getWindow().getHeight() - (double)y2 * scale)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private static class FamiliarEntry {
        final UUID id;
        final AbstractSpellCastingPet familiar;
        final String displayName;
        final float health;
        final boolean isLinkedToOtherBed;

        FamiliarEntry(UUID id, AbstractSpellCastingPet familiar, String displayName, float health, boolean isLinkedToOtherBed) {
            this.id = id;
            this.familiar = familiar;
            this.displayName = displayName;
            this.health = health;
            this.isLinkedToOtherBed = isLinkedToOtherBed;
        }
    }
}

