/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.network;

import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncBedLinkDataPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncBedLinkDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"sync_bed_link_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBedLinkDataPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncBedLinkDataPacket::write, SyncBedLinkDataPacket::new);
    private final CompoundTag bedLinkData;

    public SyncBedLinkDataPacket(CompoundTag bedLinkData) {
        this.bedLinkData = bedLinkData;
    }

    public SyncBedLinkDataPacket(FriendlyByteBuf buf) {
        this.bedLinkData = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.bedLinkData);
    }

    public static void handle(SyncBedLinkDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> FamiliarManager.syncBedData(packet.bedLinkData));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

