/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.network;

import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetStorageModePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetStorageModePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"set_storage_mode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetStorageModePacket> STREAM_CODEC = CustomPacketPayload.codec(SetStorageModePacket::write, SetStorageModePacket::new);
    private final BlockPos blockPos;
    private final boolean storeMode;

    public SetStorageModePacket(BlockPos blockPos, boolean storeMode) {
        this.blockPos = blockPos;
        this.storeMode = storeMode;
    }

    public SetStorageModePacket(FriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.storeMode = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeBoolean(this.storeMode);
    }

    public static void handle(SetStorageModePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                FamiliarManager.handleSetStorageMode(serverPlayer, packet.blockPos, packet.storeMode);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

