/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.network;

import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenFamiliarStoragePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenFamiliarStoragePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"open_familiar_storage"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenFamiliarStoragePacket> STREAM_CODEC = CustomPacketPayload.codec(OpenFamiliarStoragePacket::write, OpenFamiliarStoragePacket::new);
    private final BlockPos blockPos;

    public OpenFamiliarStoragePacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public OpenFamiliarStoragePacket(FriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
    }

    public static void handle(OpenFamiliarStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> FamiliarManager.openStorageScreen(packet.blockPos));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

