/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.network;

import java.util.UUID;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class LinkFamiliarToBedPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<LinkFamiliarToBedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"familiarslib", (String)"link_familiar_to_bed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LinkFamiliarToBedPacket> STREAM_CODEC = CustomPacketPayload.codec(LinkFamiliarToBedPacket::write, LinkFamiliarToBedPacket::new);
    private final BlockPos bedPos;
    private final UUID familiarId;

    public LinkFamiliarToBedPacket(BlockPos bedPos, UUID familiarId) {
        this.bedPos = bedPos;
        this.familiarId = familiarId;
    }

    public LinkFamiliarToBedPacket(FriendlyByteBuf buf) {
        this.bedPos = buf.readBlockPos();
        this.familiarId = buf.readBoolean() ? buf.readUUID() : null;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.bedPos);
        buf.writeBoolean(this.familiarId != null);
        if (this.familiarId != null) {
            buf.writeUUID(this.familiarId);
        }
    }

    public static void handle(LinkFamiliarToBedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                FamiliarManager.linkFamiliarToBed(serverPlayer, packet.bedPos, packet.familiarId);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

