/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.item;

import java.util.List;
import net.alshanex.familiarslib.advancements.SimpleAdvancementTrigger;
import net.alshanex.familiarslib.registry.CriteriaTriggersRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConsumableItem
extends Item {
    public AbstractConsumableItem() {
        super(new Item.Properties().stacksTo(16).rarity(Rarity.UNCOMMON));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.triggerConsumableAdvancement(serverPlayer);
        }
        return this.applyConsumableEffect(stack, player, interactionTarget, usedHand);
    }

    protected void triggerConsumableAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.CONSUMABLE_TRIGGER.get())).trigger(player);
    }

    protected InteractionResult applyConsumableEffect(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        lines.add((Component)Component.translatable((String)"ui.familiarslib.consumable_item").withStyle(ChatFormatting.GOLD));
        lines.add((Component)Component.translatable((String)"ui.familiarslib.consumable_item_desc").withStyle(ChatFormatting.WHITE));
    }
}

